/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverFluid;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverItem;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.util.ResourceLocation;

public class AttachmentRegistry {
    private static final Map<ResourceLocation, BiFunction<TileGrid, Byte, Attachment>> REGISTRY = new HashMap<ResourceLocation, BiFunction<TileGrid, Byte, Attachment>>();
    private static final TIntObjectHashMap<ResourceLocation> CONVERSION_MAP = new TIntObjectHashMap();
    public static final ResourceLocation FACADE = new ResourceLocation("thermaldynamics", "facade");
    public static final ResourceLocation SERVO_FLUID = new ResourceLocation("thermaldynamics", "servo_fluid");
    public static final ResourceLocation SERVO_ITEM = new ResourceLocation("thermaldynamics", "servo_item");
    public static final ResourceLocation FILTER_FLUID = new ResourceLocation("thermaldynamics", "filter_fluid");
    public static final ResourceLocation FILTER_ITEM = new ResourceLocation("thermaldynamics", "filter_item");
    public static final ResourceLocation RETRIEVER_FLUID = new ResourceLocation("thermaldynamics", "retriever_fluid");
    public static final ResourceLocation RETRIEVER_ITEM = new ResourceLocation("thermaldynamics", "retriever_item");
    public static final ResourceLocation RELAY = new ResourceLocation("thermaldynamics", "relay");

    public static Attachment convertLegacyAttachment(TileGrid tile, byte side, int oldId) {
        ResourceLocation id = (ResourceLocation)CONVERSION_MAP.get(oldId);
        if (REGISTRY.containsKey(id)) {
            return REGISTRY.get(id).apply(tile, side);
        }
        throw new RuntimeException("Illegal Attachment ID - Legacy Conversion Failure");
    }

    public static Attachment createAttachment(TileGrid tile, byte side, ResourceLocation id) {
        if (REGISTRY.containsKey(id)) {
            return REGISTRY.get(id).apply(tile, side);
        }
        throw new RuntimeException("Illegal Attachment ID");
    }

    public static boolean registerAttachment(ResourceLocation id, BiFunction<TileGrid, Byte, Attachment> function) {
        if (!REGISTRY.containsKey(id)) {
            REGISTRY.put(id, function);
            return true;
        }
        return false;
    }

    private static void registerConversion(int oldId, ResourceLocation id) {
        CONVERSION_MAP.put(oldId, (Object)id);
    }

    static {
        AttachmentRegistry.registerAttachment(SERVO_FLUID, ServoFluid::new);
        AttachmentRegistry.registerAttachment(SERVO_ITEM, ServoItem::new);
        AttachmentRegistry.registerAttachment(FILTER_FLUID, FilterFluid::new);
        AttachmentRegistry.registerAttachment(FILTER_ITEM, FilterItem::new);
        AttachmentRegistry.registerAttachment(RETRIEVER_FLUID, RetrieverFluid::new);
        AttachmentRegistry.registerAttachment(RETRIEVER_ITEM, RetrieverItem::new);
        AttachmentRegistry.registerAttachment(RELAY, Relay::new);
        AttachmentRegistry.registerConversion(0, FACADE);
        AttachmentRegistry.registerConversion(1, SERVO_FLUID);
        AttachmentRegistry.registerConversion(2, SERVO_ITEM);
        AttachmentRegistry.registerConversion(3, FILTER_FLUID);
        AttachmentRegistry.registerConversion(4, FILTER_ITEM);
        AttachmentRegistry.registerConversion(5, RETRIEVER_FLUID);
        AttachmentRegistry.registerConversion(6, RETRIEVER_ITEM);
        AttachmentRegistry.registerConversion(7, RELAY);
    }
}

