/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ReColourRecipe
extends RecipeBase {
    private Ingredient ingredient;
    private Ingredient dyeIngredient;

    public ReColourRecipe(@Nonnull ItemStack result, Ingredient ingredient, Ingredient dyeIngredient) {
        super(new ResourceLocation("enderstorage", "crafting_recipe"), result, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{ingredient}));
        this.ingredient = ingredient;
        this.dyeIngredient = dyeIngredient;
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        int foundRow = 0;
        Frequency currFreq = new Frequency();
        for (int row = 1; row < 3; ++row) {
            ItemStack stack = inv.func_70463_b(1, row);
            if (!this.ingredient.apply(stack)) continue;
            foundRow = row;
            currFreq = Frequency.readFromStack(stack);
            break;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < foundRow; ++row) {
                EnumColour colour;
                ItemStack stack = inv.func_70463_b(col, row);
                if (stack.func_190926_b() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null || colours[col] != null) continue;
                colours[col] = colour;
            }
        }
        currFreq.setLeft(colours[0]);
        currFreq.setMiddle(colours[1]);
        currFreq.setRight(colours[2]);
        return currFreq.writeToStack(super.func_77572_b(inv));
    }

    @Override
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack stack;
        int row;
        int col;
        if (inv.func_191420_l()) {
            return false;
        }
        boolean inputFound = false;
        int foundRow = 0;
        for (int row2 = 1; row2 < 3; ++row2) {
            ItemStack stack2 = inv.func_70463_b(1, row2);
            if (stack2.func_190926_b() || !this.ingredient.apply(stack2)) continue;
            foundRow = row2;
            inputFound = true;
            break;
        }
        if (!inputFound) {
            return false;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        boolean hasDye = false;
        for (col = 0; col < 3; ++col) {
            for (row = 0; row < foundRow; ++row) {
                EnumColour colour;
                stack = inv.func_70463_b(col, row);
                if (stack.func_190926_b() || !this.dyeIngredient.apply(stack) || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                if (colours[col] != null) {
                    return false;
                }
                hasDye = true;
                colours[col] = colour;
            }
        }
        if (hasDye) {
            for (col = 0; col < 3; ++col) {
                for (row = 0; row < 3; ++row) {
                    stack = inv.func_70463_b(col, row);
                    if (stack.func_190926_b()) continue;
                    if (row >= foundRow && this.dyeIngredient.apply(stack)) {
                        return false;
                    }
                    if (this.ingredient.apply(stack) || this.dyeIngredient.apply(stack)) continue;
                    return false;
                }
            }
        }
        return hasDye;
    }

    public boolean func_192399_d() {
        return true;
    }
}

