/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.entity;

import java.util.UUID;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityPlayerMob
extends EntityMob {
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityPlayerMob.class, (DataSerializer)DataSerializers.field_187198_h);
    private float mobWidth = -1.0f;
    private float mobHeight;

    public EntityPlayerMob(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsBaby", this.func_70631_g_());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setChild(compound.func_74767_n("IsBaby"));
    }

    public float func_70047_e() {
        float height = 1.74f;
        return this.func_70631_g_() ? 1.74f : 0.93f;
    }

    public final void func_70105_a(float width, float height) {
        boolean flag = this.mobWidth > 0.0f && this.mobHeight > 0.0f;
        this.mobWidth = width;
        this.mobHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (MathsUtils.tryPercentage(this.getChildSpawnChance(difficulty, livingdata))) {
            this.setChild(true);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public double getChildSpawnChance(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return 0.05;
    }

    public final void multiplySize(float size) {
        super.func_70105_a(this.mobWidth * size, this.mobHeight * size);
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            speed.func_111124_b(BABY_SPEED_BOOST);
            if (isChild) {
                speed.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.setChildSize(isChild);
    }
}

