/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeUtils {
    public static List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static int getBiomeSize(World world) {
        String settings = world.func_72912_H().func_82571_y();
        return ChunkGeneratorSettings.Factory.func_177865_a((String)settings).func_177864_b().field_177780_G;
    }

    public static int getDistanceToBiome(EntityPlayer player, int x, int z) {
        return (int)player.func_70011_f((double)x, player.field_70163_u, (double)z);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getBiomeName(Biome biome) {
        if (biome != null && biome.func_185359_l() != null) {
            if (ConfigHandler.fixBiomeNames) {
                String original = biome.func_185359_l();
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return biome.func_185359_l();
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(Biome.func_185357_a((int)biomeID));
    }

    @SideOnly(value=Side.CLIENT)
    public static String getBiomeSource(Biome biome) {
        if (biome != null && biome.getRegistryName() != null) {
            String registryEntry = biome.getRegistryName().toString();
            String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
            ModContainer sourceContainer = (ModContainer)Loader.instance().getIndexedModList().get(modid);
            return sourceContainer != null ? sourceContainer.getName() : modid;
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public static String getBiomeSource(int biomeID) {
        return BiomeUtils.getBiomeSource(Biome.func_185357_a((int)biomeID));
    }

    public static boolean biomeIsBlacklisted(Biome biome) {
        List<String> biomeBlacklist = ConfigHandler.getBiomeBlacklist();
        ResourceLocation biomeResourceLocation = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
        return biomeBlacklist.contains(String.valueOf(Biome.func_185362_a((Biome)biome))) || biomeResourceLocation != null && biomeBlacklist.contains(biomeResourceLocation.toString());
    }
}

