/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.parser.distribution.base.AbstractDistParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.distribution.Distribution;
import cofh.cofhworld.world.distribution.DistributionSurface;
import cofh.cofhworld.world.distribution.DistributionTopBlock;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class DistParserSurface
extends AbstractDistParser {
    @Override
    protected List<WeightedBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedBlock(Blocks.field_150348_b, -1), new WeightedBlock(Blocks.field_150346_d, -1), new WeightedBlock((Block)Blocks.field_150349_c, -1), new WeightedBlock((Block)Blocks.field_150354_m, -1), new WeightedBlock(Blocks.field_150351_n, -1), new WeightedBlock(Blocks.field_150433_aE, -1), new WeightedBlock(Blocks.field_150350_a, -1), new WeightedBlock((Block)Blocks.field_150355_j, -1));
    }

    @Override
    @Nonnull
    protected Distribution getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, boolean retrogen, Logger log) {
        List<WeightedBlock> matList = this.defaultMaterial;
        if (genObject.hasPath("material")) {
            matList = new ArrayList<WeightedBlock>();
            if (!BlockData.parseBlockList(genObject.getValue("material"), matList, false)) {
                log.warn("Invalid material list! Using default list.");
                matList = this.defaultMaterial;
            }
        }
        if (genObject.hasPath("follow-terrain") && genObject.getBoolean("follow-terrain")) {
            return new DistributionTopBlock(featureName, gen, matList, numClusters, retrogen);
        }
        return new DistributionSurface(featureName, gen, matList, numClusters, retrogen);
    }
}

