/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler.annotations;

import com.google.common.collect.Maps;
import elec332.core.ElecCore;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.Logger;

public abstract class AbstractAnnotationProcessor
implements IASMDataProcessor {
    protected static final Logger logger = ElecCore.logger;
    private final Map<Class<? extends Annotation>, Consumer<ASMDataTable.ASMData>> processList = Maps.newHashMap();

    public AbstractAnnotationProcessor() {
        this.registerProcesses();
    }

    protected abstract void registerProcesses();

    protected void registerDataProcessor(Class<? extends Annotation> clazz, Consumer<ASMDataTable.ASMData> consumer, boolean register) {
        if (register) {
            this.registerDataProcessor(clazz, consumer);
        }
    }

    protected void registerDataProcessor(Class<? extends Annotation> clazz, Consumer<ASMDataTable.ASMData> consumer) {
        if (clazz == null || consumer == null) {
            throw new IllegalArgumentException();
        }
        this.processList.put(clazz, consumer);
    }

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        for (Map.Entry<Class<? extends Annotation>, Consumer<ASMDataTable.ASMData>> entry : this.processList.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            for (ASMDataTable.ASMData data : asmData.getAnnotationList(entry.getKey())) {
                entry.getValue().accept(data);
            }
        }
    }

    @Nonnull
    protected Object instantiate(Class<?> clazz, Object ... params) {
        return this.instantiate(clazz, true, params);
    }

    @Nullable
    protected Object instantiate(Class<?> clazz, boolean crash, Object ... params) {
        try {
            Constructor<?> c = null;
            if (params == null || params.length == 0) {
                c = clazz.getDeclaredConstructor(new Class[0]);
            }
            if (c == null) {
                Class[] ctor = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    ctor[i] = params[i].getClass();
                }
                c = clazz.getDeclaredConstructor(ctor);
            }
            c.setAccessible(true);
            return c.newInstance(params);
        }
        catch (Exception e) {
            if (crash) {
                throw new RuntimeException(e);
            }
            logger.error("Error invocating class: " + clazz.getCanonicalName());
            logger.error((Object)e);
            return null;
        }
    }

    @Nonnull
    protected Class<?> loadClass(ASMDataTable.ASMData asmData) {
        return this.loadClass(asmData, true);
    }

    @Nullable
    protected Class<?> loadClass(ASMDataTable.ASMData asmData, boolean crash) {
        try {
            return Class.forName(asmData.getClassName(), true, (ClassLoader)Loader.instance().getModClassLoader());
        }
        catch (Exception e) {
            if (crash) {
                throw new RuntimeException(e);
            }
            logger.error("Error loading class: " + asmData.getClassName());
            logger.error((Object)e);
            return null;
        }
    }
}

