/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.items.materials.MaterialType;
import appeng.items.storage.AbstractStorageCell;
import net.minecraft.item.ItemStack;

public final class BasicItemStorageCell
extends AbstractStorageCell<IAEItemStack> {
    protected final int perType;
    protected final double idleDrain;

    public BasicItemStorageCell(MaterialType whichCell, int kilobytes) {
        super(whichCell, kilobytes);
        switch (whichCell) {
            case CELL1K_PART: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case CELL4K_PART: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case CELL16K_PART: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case CELL64K_PART: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }
}

