/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tesla.api.implementation;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class BaseTeslaContainer
implements ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
INBTSerializable<NBTTagCompound> {
    private long stored;
    private long capacity;
    private long inputRate;
    private long outputRate;

    public BaseTeslaContainer() {
        this(5000L, 50L, 50L);
    }

    public BaseTeslaContainer(long capacity, long input, long output) {
        this(0L, capacity, input, output);
    }

    public BaseTeslaContainer(long power, long capacity, long input, long output) {
        this.stored = power;
        this.capacity = capacity;
        this.inputRate = input;
        this.outputRate = output;
    }

    public BaseTeslaContainer(NBTTagCompound dataTag) {
        this.deserializeNBT(dataTag);
    }

    @Override
    public long getStoredPower() {
        return this.stored;
    }

    @Override
    public long givePower(long Tesla2, boolean simulated) {
        long acceptedTesla = Math.min(this.getCapacity() - this.stored, Math.min(this.getInputRate(), Tesla2));
        if (!simulated) {
            this.stored += acceptedTesla;
        }
        return acceptedTesla;
    }

    @Override
    public long takePower(long Tesla2, boolean simulated) {
        long removedPower = Math.min(this.stored, Math.min(this.getOutputRate(), Tesla2));
        if (!simulated) {
            this.stored -= removedPower;
        }
        return removedPower;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74772_a("TeslaPower", this.stored);
        dataTag.func_74772_a("TeslaCapacity", this.capacity);
        dataTag.func_74772_a("TeslaInput", this.inputRate);
        dataTag.func_74772_a("TeslaOutput", this.outputRate);
        return dataTag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.stored = nbt.func_74763_f("TeslaPower");
        if (nbt.func_74764_b("TeslaCapacity")) {
            this.capacity = nbt.func_74763_f("TeslaCapacity");
        }
        if (nbt.func_74764_b("TeslaInput")) {
            this.inputRate = nbt.func_74763_f("TeslaInput");
        }
        if (nbt.func_74764_b("TeslaOutput")) {
            this.outputRate = nbt.func_74763_f("TeslaOutput");
        }
        if (this.stored > this.getCapacity()) {
            this.stored = this.getCapacity();
        }
    }

    public BaseTeslaContainer setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.stored > capacity) {
            this.stored = capacity;
        }
        return this;
    }

    public long getInputRate() {
        return this.inputRate;
    }

    public BaseTeslaContainer setInputRate(long rate) {
        this.inputRate = rate;
        return this;
    }

    public long getOutputRate() {
        return this.outputRate;
    }

    public BaseTeslaContainer setOutputRate(long rate) {
        this.outputRate = rate;
        return this;
    }

    public BaseTeslaContainer setTransferRate(long rate) {
        this.setInputRate(rate);
        this.setOutputRate(rate);
        return this;
    }
}

