/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import mekanism.common.Mekanism;
import mekanism.common.base.IGuiProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.generators.common.block.states.BlockStateGenerator;
import mekanism.generators.common.inventory.container.ContainerBioGenerator;
import mekanism.generators.common.inventory.container.ContainerGasGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator64;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator8;
import mekanism.generators.common.inventory.container.ContainerReactorController;
import mekanism.generators.common.inventory.container.ContainerSolarGenerator;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator64;
import mekanism.generators.common.tile.TileEntityHeatGenerator8;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.reactor.TileEntityReactorGlass;
import mekanism.generators.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class GeneratorsCommonProxy
implements IGuiProvider {
    private static void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation("mekanismgenerators", name));
    }

    public void registerTileEntities() {
        GeneratorsCommonProxy.registerTileEntity(TileEntityAdvancedSolarGenerator.class, "advanced_solar_generator");
        GeneratorsCommonProxy.registerTileEntity(TileEntityBioGenerator.class, "bio_generator");
        GeneratorsCommonProxy.registerTileEntity(TileEntityElectromagneticCoil.class, "electromagnetic_coil");
        GeneratorsCommonProxy.registerTileEntity(TileEntityGasGenerator.class, "gas_generator");
        GeneratorsCommonProxy.registerTileEntity(TileEntityHeatGenerator.class, "heat_generator");
        GeneratorsCommonProxy.registerTileEntity(TileEntityHeatGenerator8.class, "heat_generator8");
        GeneratorsCommonProxy.registerTileEntity(TileEntityHeatGenerator64.class, "heat_generator64");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorController.class, "reactor_controller");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorFrame.class, "reactor_frame");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorGlass.class, "reactor_glass");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorLaserFocusMatrix.class, "reactor_laser_focus");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorLogicAdapter.class, "reactor_logic_adapter");
        GeneratorsCommonProxy.registerTileEntity(TileEntityReactorPort.class, "reactor_port");
        GeneratorsCommonProxy.registerTileEntity(TileEntityRotationalComplex.class, "rotational_complex");
        GeneratorsCommonProxy.registerTileEntity(TileEntitySaturatingCondenser.class, "saturating_condenser");
        GeneratorsCommonProxy.registerTileEntity(TileEntitySolarGenerator.class, "solar_generator");
        GeneratorsCommonProxy.registerTileEntity(TileEntityTurbineCasing.class, "turbine_casing");
        GeneratorsCommonProxy.registerTileEntity(TileEntityTurbineRotor.class, "turbine_rod");
        GeneratorsCommonProxy.registerTileEntity(TileEntityTurbineValve.class, "turbine_valve");
        GeneratorsCommonProxy.registerTileEntity(TileEntityTurbineVent.class, "turbine_vent");
        GeneratorsCommonProxy.registerTileEntity(TileEntityWindGenerator.class, "wind_turbine");
    }

    public void registerTESRs() {
    }

    public void registerItemRenders() {
    }

    public void registerBlockRenders() {
    }

    public void preInit() {
    }

    public void loadConfiguration() {
        MekanismConfig.local().generators.load(Mekanism.configuration);
        this.setGasGeneratorMaxEnergy();
        if (Mekanism.configuration.hasChanged()) {
            Mekanism.configuration.save();
        }
    }

    protected void setGasGeneratorMaxEnergy() {
        BlockStateGenerator.GeneratorType.GAS_GENERATOR.maxEnergy = MekanismConfig.local().general.FROM_H2.val() * 100.0;
    }

    public Object getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        return null;
    }

    public Container getServerGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                if (tileEntity instanceof TileEntityHeatGenerator8) {
                    return new ContainerHeatGenerator8(player.field_71071_by, (TileEntityHeatGenerator8)tileEntity);
                }
                if (tileEntity instanceof TileEntityHeatGenerator64) {
                    return new ContainerHeatGenerator64(player.field_71071_by, (TileEntityHeatGenerator64)tileEntity);
                }
                return new ContainerHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new ContainerSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new ContainerGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new ContainerBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new ContainerWindGenerator(player.field_71071_by, (TileEntityWindGenerator)tileEntity);
            }
            case 6: {
                return new ContainerFilter(player.field_71071_by, (TileEntityContainerBlock)((TileEntityTurbineCasing)tileEntity));
            }
            case 7: {
                return new ContainerNull(player, (TileEntityContainerBlock)((TileEntityTurbineCasing)tileEntity));
            }
            case 10: {
                return new ContainerReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
        }
        return null;
    }
}

