/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ServerUtils {
    public static MinecraftServer mc() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static EntityPlayerMP getPlayer(String playername) {
        return ServerUtils.mc().func_184103_al().func_152612_a(playername);
    }

    public static List<EntityPlayerMP> getPlayers() {
        return ServerUtils.mc().func_184103_al().func_181057_v();
    }

    public static ArrayList<EntityPlayer> getPlayersInDimension(int dimension) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (EntityPlayer entityPlayer : ServerUtils.getPlayers()) {
            if (entityPlayer.field_71093_bK != dimension) continue;
            players.add(entityPlayer);
        }
        return players;
    }

    public static boolean isPlayerLoadingChunk(EntityPlayerMP player, ChunkPos chunk) {
        return player.func_71121_q().func_184164_w().func_152621_a(chunk.field_77276_a, chunk.field_77275_b);
    }

    public static GameProfile getGameProfile(String username) {
        String lower;
        PlayerProfileCache.ProfileEntry entry;
        EntityPlayerMP player = ServerUtils.mc().func_184103_al().func_152612_a(username);
        if (player != null) {
            return player.func_146103_bH();
        }
        PlayerProfileCache cache = ServerUtils.mc().func_152358_ax();
        if (cache != null && (entry = (PlayerProfileCache.ProfileEntry)cache.field_152661_c.get(lower = username.toLowerCase(Locale.ROOT))) != null) {
            return entry.func_152668_a();
        }
        MinecraftSessionService session = ServerUtils.mc().func_147130_as();
        if (session != null) {
            try {
                GameProfile lookup = new GameProfile(null, username);
                session.fillProfileProperties(lookup, false);
                if (lookup.getId() != null) {
                    return lookup;
                }
            }
            catch (Exception e) {
                FMLCommonHandler.instance().getFMLLogger().warn("Could not fetch GameProfile for {}: {}", (Object)username, (Object)e.getMessage());
            }
        }
        UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        return new GameProfile(offlineUUID, username);
    }

    public static boolean isPlayerOP(UUID uuid) {
        GameProfile profile = ServerUtils.mc().func_152358_ax().func_152652_a(uuid);
        return profile != null && ServerUtils.mc().func_184103_al().func_152596_g(profile);
    }

    public static boolean isPlayerOP(String username) {
        GameProfile prof = ServerUtils.getGameProfile(username);
        return prof != null && ServerUtils.mc().func_184103_al().func_152596_g(prof);
    }

    public static boolean isPlayerOwner(String username) {
        return ServerUtils.mc().func_71264_H() && ServerUtils.mc().func_71214_G().equalsIgnoreCase(username);
    }

    public static void sendChatToAll(ITextComponent msg) {
        for (EntityPlayer entityPlayer : ServerUtils.getPlayers()) {
            entityPlayer.func_145747_a(msg);
        }
    }

    public static void openSMPContainer(EntityPlayerMP player, Container container, BiConsumer<EntityPlayerMP, Integer> packetSender) {
        player.func_71117_bO();
        player.func_71128_l();
        packetSender.accept(player, player.field_71139_cq);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }
}

