/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.backend.ModifyingBakedModel;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.compatibility.ICompatPerspectiveAwareModel;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.NullRecipe;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotReadOnly;
import com.rwtema.extrautils2.gui.backend.WidgetTextTranslate;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileCrafter
extends TileAdvInteractor
implements ITickable,
IDynamicHandler,
ITESRHook {
    private final NBTSerializable.NBTEnum<SideMode> sideWest = this.registerNBT("sideWest", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTEnum<SideMode> sideUp = this.registerNBT("sideUp", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTEnum<SideMode> sideNorth = this.registerNBT("sideNorth", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTEnum<SideMode> sideEast = this.registerNBT("sideEast", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTEnum<SideMode> sideDown = this.registerNBT("sideDown", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTEnum<SideMode> sideSouth = this.registerNBT("sideSouth", new NBTSerializable.NBTEnum<SideMode>(SideMode.NONE));
    private final NBTSerializable.NBTBoolean autoInput = this.registerNBT("autoInput", new NBTSerializable.NBTBoolean(false));
    private final NBTSerializable.NBTBoolean autoOutput = this.registerNBT("autoOutput", new NBTSerializable.NBTBoolean(false));
    private final ItemStackHandler output = this.registerNBT("output", new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileCrafter.this.func_70296_d();
            TileCrafter.this.markForUpdate();
        }
    });
    IRecipe curRecipe = NullRecipe.INSTANCE;
    Predicate<ItemStack>[] recipeMatchers = new Predicate[0];
    ItemStack[] genericStacks = new ItemStack[0];
    private final ItemStackHandler contents = this.registerNBT("contents", new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileCrafter.this.func_70296_d();
            TileCrafter.this.markForUpdate();
            if (TileCrafter.this.field_145850_b != null) {
                TileCrafter.this.field_145850_b.func_184138_a(TileCrafter.this.func_174877_v(), TileCrafter.this.field_145850_b.func_180495_p(TileCrafter.this.func_174877_v()), TileCrafter.this.field_145850_b.func_180495_p(TileCrafter.this.func_174877_v()), 3);
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileCrafter.this.recipeMatchers == null || TileCrafter.this.curRecipe == NullRecipe.INSTANCE) {
                return stack;
            }
            boolean matches = false;
            for (Predicate<ItemStack> m : TileCrafter.this.recipeMatchers) {
                if (m == null || !m.test(stack)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return stack;
            }
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack existing;
                if (i == slot || (existing = this.getStackInSlot(i)).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)stack)) continue;
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            TileCrafter.this.func_70296_d();
            TileCrafter.this.markForUpdate();
        }
    });
    private final IItemHandler ioHandler = new IItemHandler(){
        private final int inSize;
        private final int outSize;
        {
            this.inSize = TileCrafter.this.contents.getSlots();
            this.outSize = TileCrafter.this.output.getSlots();
        }

        public int getSlots() {
            return this.inSize + this.outSize;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < this.inSize ? TileCrafter.this.contents.getStackInSlot(slot) : TileCrafter.this.output.getStackInSlot(slot - this.inSize);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= this.inSize) {
                return stack;
            }
            return TileCrafter.this.contents.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < this.inSize) {
                return ItemStack.field_190927_a;
            }
            return TileCrafter.this.output.extractItem(slot - this.inSize, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return slot < this.inSize ? TileCrafter.this.contents.getSlotLimit(slot) : TileCrafter.this.output.getSlotLimit(slot - this.inSize);
        }
    };
    private final ItemStackHandler recipeSlots = this.registerNBT("recipe", new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileCrafter.this.recalculateRecipe();
        }
    });
    private final SingleStackHandler ghostOutput = this.registerNBT("ghostOutput", new SingleStackHandler());
    private final NBTSerializable.NBTEnum<ContainerMode> mode = this.registerNBT("mode", new NBTSerializable.NBTEnum<ContainerMode>(ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT));

    public TileCrafter() {
        this.curRecipe = NullRecipe.INSTANCE;
    }

    private EnumFacing getFront() {
        return (EnumFacing)this.getBlockState().func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL);
    }

    private EnumFacing localToWorld(EnumFacing local) {
        switch (local) {
            case NORTH: {
                return this.getFront();
            }
            case EAST: {
                return this.getFront().func_176735_f();
            }
            case SOUTH: {
                return this.getFront().func_176734_d();
            }
            case WEST: {
                return this.getFront().func_176746_e();
            }
        }
        return local;
    }

    public SideMode getSideMode(EnumFacing face) {
        switch (face) {
            case WEST: {
                return (SideMode)((Object)this.sideWest.value);
            }
            case UP: {
                return (SideMode)((Object)this.sideUp.value);
            }
            case NORTH: {
                return (SideMode)((Object)this.sideNorth.value);
            }
            case EAST: {
                return (SideMode)((Object)this.sideEast.value);
            }
            case DOWN: {
                return (SideMode)((Object)this.sideDown.value);
            }
            case SOUTH: {
                return (SideMode)((Object)this.sideSouth.value);
            }
        }
        return SideMode.NONE;
    }

    public void setSideMode(EnumFacing face, SideMode mode) {
        switch (face) {
            case WEST: {
                this.sideWest.value = mode;
                break;
            }
            case UP: {
                this.sideUp.value = mode;
                break;
            }
            case NORTH: {
                this.sideNorth.value = mode;
                break;
            }
            case EAST: {
                this.sideEast.value = mode;
                break;
            }
            case DOWN: {
                this.sideDown.value = mode;
                break;
            }
            case SOUTH: {
                this.sideSouth.value = mode;
                break;
            }
        }
    }

    private void recalculateRecipe() {
        InventoryCrafting grid = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            grid.func_70299_a(i, this.recipeSlots.getStackInSlot(i).func_77946_l());
        }
        IRecipe match = CraftingManager.func_192413_b((InventoryCrafting)grid, (World)this.field_145850_b);
        if (match == null || match.func_77571_b().func_190926_b()) {
            this.curRecipe = NullRecipe.INSTANCE;
            this.ghostOutput.setStack(ItemStack.field_190927_a);
            this.recipeMatchers = new Predicate[0];
            this.genericStacks = new ItemStack[0];
            this.markForUpdate();
            return;
        }
        this.curRecipe = match;
        this.ghostOutput.setStack(this.curRecipe.func_77571_b().func_77946_l());
        this.markForUpdate();
        List inputs = this.curRecipe.func_192400_c().stream().map(ing -> {
            ItemStack[] arr = ing.func_193365_a();
            return arr.length > 0 ? Arrays.asList(arr) : Collections.emptyList();
        }).collect(Collectors.toList());
        this.recipeMatchers = new Predicate[9];
        this.genericStacks = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            List opts;
            List list = opts = i < inputs.size() ? (List)inputs.get(i) : Collections.emptyList();
            if (opts.isEmpty()) {
                this.genericStacks[i] = ItemStack.field_190927_a;
                this.recipeMatchers[i] = stack -> stack.func_190926_b();
                continue;
            }
            this.genericStacks[i] = ((ItemStack)opts.get(0)).func_77946_l();
            this.recipeMatchers[i] = stack -> opts.stream().anyMatch(o -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)o));
        }
    }

    public static String errLog(IRecipe recipe) {
        if (recipe == null) {
            return "[null recipe]";
        }
        try {
            return "[" + recipe.getClass() + "=" + recipe.func_77571_b() + "]";
        }
        catch (Exception err) {
            return "[" + recipe.getClass() + "=ERROR_GETTING_RECIPE_OUTPUT]";
        }
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.ioHandler;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            packet.writeItemStack(this.contents.getStackInSlot(i));
        }
        packet.writeItemStack(this.ghostOutput.getStack());
        packet.writeByte(((SideMode)((Object)this.sideWest.value)).ordinal());
        packet.writeByte(((SideMode)((Object)this.sideUp.value)).ordinal());
        packet.writeByte(((SideMode)((Object)this.sideNorth.value)).ordinal());
        packet.writeByte(((SideMode)((Object)this.sideEast.value)).ordinal());
        packet.writeByte(((SideMode)((Object)this.sideDown.value)).ordinal());
        packet.writeByte(((SideMode)((Object)this.sideSouth.value)).ordinal());
        packet.writeBoolean(this.autoInput.value);
        packet.writeBoolean(this.autoOutput.value);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            this.contents.setStackInSlot(i, packet.readItemStack());
        }
        this.ghostOutput.setStack(packet.readItemStack());
        this.sideWest.value = SideMode.values()[packet.readByte()];
        this.sideUp.value = SideMode.values()[packet.readByte()];
        this.sideNorth.value = SideMode.values()[packet.readByte()];
        this.sideEast.value = SideMode.values()[packet.readByte()];
        this.sideDown.value = SideMode.values()[packet.readByte()];
        this.sideSouth.value = SideMode.values()[packet.readByte()];
        this.autoInput.value = packet.readBoolean();
        this.autoOutput.value = packet.readBoolean();
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator(new IItemHandler[]{this.contents, this.upgrades});
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.recalculateRecipe();
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new CrafterContainer(this, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, IVertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
        Pair pair;
        ItemStack stack = this.ghostOutput.getStack();
        if (StackHelper.isNull(stack)) {
            return;
        }
        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        IBakedModel finalModel = duplicateModel.func_188617_f().handleItemState(duplicateModel, stack, this.field_145850_b, null);
        if (finalModel instanceof ICompatPerspectiveAwareModel && (pair = finalModel.handlePerspective(ItemCameraTransforms.TransformType.GROUND)).getLeft() != null) {
            finalModel = (IBakedModel)pair.getLeft();
        }
        finalModel = ModifyingBakedModel.create(finalModel, (original, base, state1, side, rand) -> {
            float t = MCTimer.renderTimer / 64.0f;
            float c = MathHelper.func_76134_b((float)t);
            float s = MathHelper.func_76126_a((float)t);
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(original.size());
            for (BakedQuad bakedQuad : original) {
                int[] data = Arrays.copyOf(bakedQuad.func_178209_a(), 28);
                for (int i = 0; i < 28; i += 7) {
                    float ax = Float.intBitsToFloat(data[i]) - 0.5f;
                    float ay = Float.intBitsToFloat(data[i + 1]);
                    float az = Float.intBitsToFloat(data[i + 2]) - 0.5f;
                    data[i] = Float.floatToRawIntBits(0.5f + (ax * c - az * s) * 0.25f);
                    data[i + 1] = Float.floatToRawIntBits(0.05f + ay * 0.25f);
                    data[i + 2] = Float.floatToRawIntBits(0.5f + (ax * s + az * c) * 0.25f);
                }
                list.add(new BakedQuad(data, bakedQuad.func_178211_c(), bakedQuad.func_178210_d(), bakedQuad.func_187508_a(), bakedQuad.shouldApplyDiffuseLighting(), bakedQuad.getFormat()));
            }
            return list;
        });
        blockRenderer.func_175019_b().func_178267_a(world, finalModel, Blocks.field_150350_a.func_176223_P(), this.func_174877_v().func_177984_a(), CompatClientHelper.unwrap(renderer), false);
    }

    @Override
    public void preRender(int destroyStage) {
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
    }

    @Override
    public void postRender(int destroyStage) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    public boolean preOperate() {
        if (this.curRecipe == null || this.curRecipe == NullRecipe.INSTANCE) {
            this.ghostOutput.setStack(ItemStack.field_190927_a);
            this.markForUpdate();
            return false;
        }
        this.ghostOutput.setStack(this.curRecipe.func_77571_b().func_77946_l());
        return true;
    }

    @Override
    protected boolean operate() {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.curRecipe == NullRecipe.INSTANCE || this.recipeMatchers == null || this.recipeMatchers.length == 0) {
            return false;
        }
        EnumFacing[] locals = new EnumFacing[]{EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH};
        boolean didOutput = false;
        if (this.autoOutput.value) {
            for (EnumFacing local : locals) {
                IItemHandler ext;
                EnumFacing face;
                TileEntity te;
                SideMode mode = this.getSideMode(local);
                if (mode != SideMode.OUTPUT && mode != SideMode.INOUT || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face = this.localToWorld(local)))) == null || (ext = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                for (int i = 0; i < this.output.getSlots(); ++i) {
                    ItemStack out = this.output.getStackInSlot(i);
                    if (out.func_190926_b()) continue;
                    ItemStack rem = ItemHandlerHelper.insertItem((IItemHandler)ext, (ItemStack)out, (boolean)true);
                    int moved = out.func_190916_E() - rem.func_190916_E();
                    if (moved <= 0) continue;
                    ItemStack actually = this.output.extractItem(i, moved, false);
                    ItemHandlerHelper.insertItem((IItemHandler)ext, (ItemStack)actually, (boolean)false);
                    didOutput = true;
                }
            }
            if (didOutput) {
                this.func_70296_d();
                this.markForUpdate();
            }
        }
        ItemStack result = this.curRecipe.func_77571_b().func_77946_l();
        int stackSlot = -1;
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemStack s = this.output.getStackInSlot(i);
            if (s.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)result)) continue;
            if (stackSlot >= 0) {
                return false;
            }
            stackSlot = i;
            if (s.func_190916_E() + result.func_190916_E() <= s.func_77976_d()) continue;
            return false;
        }
        if (stackSlot < 0) {
            boolean hasEmpty = false;
            for (int i = 0; i < this.output.getSlots(); ++i) {
                if (!this.output.getStackInSlot(i).func_190926_b()) continue;
                hasEmpty = true;
                break;
            }
            if (!hasEmpty) {
                return false;
            }
        }
        class Pull {
            IItemHandler h;
            int slot;

            Pull() {
            }
        }
        ArrayList<Pull> pulls = new ArrayList<Pull>(this.recipeMatchers.length);
        for (int ingredient = 0; ingredient < this.recipeMatchers.length; ++ingredient) {
            Predicate<ItemStack> want = this.recipeMatchers[ingredient];
            if (want == null) continue;
            boolean found = false;
            for (int s = 0; s < this.contents.getSlots(); ++s) {
                if (!want.test(this.contents.getStackInSlot(s))) continue;
                final int finalS = s;
                pulls.add(new Pull(){
                    {
                        this.h = TileCrafter.this.contents;
                        this.slot = finalS;
                    }
                });
                found = true;
                break;
            }
            if (!found && this.autoInput.value) {
                for (EnumFacing local : locals) {
                    IItemHandler ext;
                    EnumFacing face;
                    TileEntity te;
                    SideMode mode = this.getSideMode(local);
                    if (mode != SideMode.INPUT && mode != SideMode.INOUT || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face = this.localToWorld(local)))) == null || (ext = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                    for (int s = 0; s < ext.getSlots(); ++s) {
                        if (!want.test(ext.getStackInSlot(s))) continue;
                        final int finalS = s;
                        pulls.add(new Pull(){
                            {
                                this.h = ext;
                                this.slot = finalS;
                            }
                        });
                        found = true;
                        break;
                    }
                    if (found) break;
                }
            }
            if (found) continue;
            return false;
        }
        for (Pull p : pulls) {
            p.h.extractItem(p.slot, 1, false);
        }
        ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)result, (boolean)false);
        didOutput = false;
        if (this.autoOutput.value) {
            for (EnumFacing local : locals) {
                IItemHandler ext;
                EnumFacing face;
                TileEntity te;
                SideMode mode = this.getSideMode(local);
                if (mode != SideMode.OUTPUT && mode != SideMode.INOUT || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face = this.localToWorld(local)))) == null || (ext = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                for (int i = 0; i < this.output.getSlots(); ++i) {
                    ItemStack out = this.output.getStackInSlot(i);
                    if (out.func_190926_b()) continue;
                    ItemStack rem = ItemHandlerHelper.insertItem((IItemHandler)ext, (ItemStack)out, (boolean)true);
                    int moved = out.func_190916_E() - rem.func_190916_E();
                    if (moved <= 0) continue;
                    ItemStack actually = this.output.extractItem(i, moved, false);
                    ItemHandlerHelper.insertItem((IItemHandler)ext, (ItemStack)actually, (boolean)false);
                    didOutput = true;
                }
            }
            if (didOutput) {
                this.func_70296_d();
                this.markForUpdate();
            }
        }
        return true;
    }

    public static class CrafterContainer
    extends DynamicContainerTile {
        private final TileCrafter tileCrafter;
        public WidgetSlotGhost[] ghostSlots = new WidgetSlotGhost[9];

        public CrafterContainer(final TileCrafter tileCrafter, EntityPlayer player) {
            super(tileCrafter);
            int i;
            int baseX;
            this.tileCrafter = tileCrafter;
            int SLOT = 18;
            int ROW1_TITLE = 20;
            int ROW2_MAIN = 56;
            int ROW_LABEL = 12;
            int ROW_INV = 20;
            int PADDING_TOP = 8;
            int totalWidth = 142;
            int baseXTitle = baseX = (162 - totalWidth) / 2;
            int MAIN_SHIFT = 27;
            int baseXMain = baseX - 27 + 22;
            int rowxOffset = baseX + 9;
            int row1Y_text = 8;
            int row2Y_craftinggrid = row1Y_text + 20;
            int row3Y_text = row2Y_craftinggrid + 56;
            int row4Y_inputinventory = row3Y_text + 12;
            int row5Y_text = row4Y_inputinventory + 20;
            int row6Y_outputinventory = row5Y_text + 12;
            int[] ghostX = new int[]{baseXMain, baseXMain + 18, baseXMain + 36};
            int[] ghostY = new int[]{row2Y_craftinggrid, row2Y_craftinggrid + 18, row2Y_craftinggrid + 36};
            int arrowX = baseXMain + 54 + 4;
            int arrowY = row2Y_craftinggrid + 18;
            int outputX = arrowX + 22 + 8;
            int outputY = arrowY;
            int stackX = outputX + 18 + 8;
            int stackY0 = row2Y_craftinggrid;
            int ancModeY = stackY0 + 18;
            int speedY = stackY0 + 36;
            int sideGridX = stackX + 18 + 8;
            int sideGridY = row2Y_craftinggrid;
            int autoInX = sideGridX;
            int autoInY = row2Y_craftinggrid;
            int autoOutX = sideGridX;
            int autoOutY = row2Y_craftinggrid + 36;
            int labelX = baseXTitle;
            int inputLabelY = row3Y_text;
            int inputSlotsY = row4Y_inputinventory;
            int outputLabelY = row5Y_text;
            int outputSlotsY = row6Y_outputinventory;
            int[][] sideCell = new int[][]{{0, 18}, {18, 0}, {18, 18}, {36, 18}, {18, 36}, {36, 36}};
            EnumFacing[] faces = new EnumFacing[]{EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH};
            this.addWidget(new WidgetTextTranslate(rowxOffset, row1Y_text, Lang.translate("AutoCrafter"), totalWidth));
            for (int ry = 0; ry < 3; ++ry) {
                for (int rx = 0; rx < 3; ++rx) {
                    WidgetSlotGhost gs;
                    int idx = rx + ry * 3;
                    this.ghostSlots[idx] = gs = new WidgetSlotGhost((IItemHandlerModifiable)tileCrafter.recipeSlots, idx, ghostX[rx], ghostY[ry]){

                        @Override
                        public void func_75215_d(ItemStack stack) {
                            tileCrafter.curRecipe = null;
                            super.func_75215_d(stack);
                        }
                    };
                    this.addWidget(gs);
                }
            }
            this.addWidget(new WidgetProgressArrowBase(arrowX, arrowY));
            this.addWidget(new WidgetSlotReadOnly(tileCrafter.ghostOutput, 0, outputX, outputY){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void renderForeground(TextureManager m, DynamicGui g, int gl, int gt) {
                }
            });
            this.addWidget(TileAdvInteractor.getRSWidget(stackX, stackY0, tileCrafter.redstone_state, tileCrafter.pulses));
            WidgetClickMCButtonChoices<ContainerMode> ancModeBtn = new WidgetClickMCButtonChoices<ContainerMode>(stackX, ancModeY){

                @Override
                protected void onSelectedServer(ContainerMode m) {
                    ((TileCrafter)tileCrafter).mode.value = m;
                }

                @Override
                public ContainerMode getSelectedValue() {
                    return (ContainerMode)((Object)((TileCrafter)tileCrafter).mode.value);
                }
            };
            ((WidgetClickMCButtonChoices)ancModeBtn.addChoice(ContainerMode.CONTAINER_ITEMS_TO_OUTPUT, new ItemStack(Items.field_151133_ar), "Move Ancillary Items To Output")).addChoice((ContainerMode)ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT, new ItemStack((Block)Blocks.field_150486_ae), "Keep Ancillary Items In Input");
            this.addWidget(ancModeBtn);
            this.addWidget(tileCrafter.upgrades.getSpeedUpgradeSlot(stackX, speedY));
            for (int i2 = 0; i2 < faces.length; ++i2) {
                final EnumFacing face = faces[i2];
                int cx = sideCell[i2][0];
                int cy = sideCell[i2][1];
                WidgetClickMCButtonChoices<SideMode> btn = new WidgetClickMCButtonChoices<SideMode>(sideGridX + cx, sideGridY + cy){

                    @Override
                    protected void onSelectedServer(SideMode m) {
                        tileCrafter.setSideMode(face, m);
                    }

                    @Override
                    public SideMode getSelectedValue() {
                        return tileCrafter.getSideMode(face);
                    }
                };
                ((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)btn.addChoice(SideMode.NONE, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "disabled"))), "Disabled")).addChoice((SideMode)SideMode.INPUT, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "in_only"))), "Input only")).addChoice((SideMode)SideMode.OUTPUT, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "out_only"))), "Output only")).addChoice((SideMode)SideMode.INOUT, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "in_and_out"))), "Input & Output");
                this.addWidget(btn);
            }
            WidgetClickMCButtonChoices<Boolean> autoInBtn = new WidgetClickMCButtonChoices<Boolean>(autoInX, autoInY){

                @Override
                protected void onSelectedServer(Boolean b) {
                    ((TileCrafter)tileCrafter).autoInput.value = b;
                }

                @Override
                public Boolean getSelectedValue() {
                    return ((TileCrafter)tileCrafter).autoInput.value;
                }
            };
            ((WidgetClickMCButtonChoices)autoInBtn.addChoice(Boolean.valueOf(false), new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "input_off"))), "Auto-Input OFF")).addChoice((Boolean)true, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "input_on"))), "Auto-Input ON");
            this.addWidget(autoInBtn);
            WidgetClickMCButtonChoices<Boolean> autoOutBtn = new WidgetClickMCButtonChoices<Boolean>(autoOutX, autoOutY){

                @Override
                protected void onSelectedServer(Boolean b) {
                    ((TileCrafter)tileCrafter).autoOutput.value = b;
                }

                @Override
                public Boolean getSelectedValue() {
                    return ((TileCrafter)tileCrafter).autoOutput.value;
                }
            };
            ((WidgetClickMCButtonChoices)autoOutBtn.addChoice(Boolean.valueOf(false), new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "output_off"))), "Auto-Output OFF")).addChoice((Boolean)true, new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("contenttweaker", "output_on"))), "Auto-Output ON");
            this.addWidget(autoOutBtn);
            this.addWidget(new WidgetTextTranslate(rowxOffset, inputLabelY, Lang.getKey("Input Inventory"), totalWidth));
            for (i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileCrafter.contents, i, rowxOffset + i * 18, inputSlotsY));
            }
            this.addWidget(new WidgetTextTranslate(rowxOffset, outputLabelY, Lang.getKey("Output Inventory"), totalWidth));
            for (i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileCrafter.output, i, rowxOffset + i * 18, outputSlotsY));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        @Override
        public ItemStack func_82846_b(EntityPlayer player, int index) {
            int machineSlots;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stackInSlot = slot.func_75211_c();
            ItemStack copy = stackInSlot.func_77946_l();
            int recipeCount = this.tileCrafter.recipeSlots.getSlots();
            int inputCount = this.tileCrafter.contents.getSlots();
            int outputCount = this.tileCrafter.output.getSlots();
            int playerStart = machineSlots = recipeCount + inputCount + outputCount;
            int playerEnd = this.field_75151_b.size();
            if (index < recipeCount) {
                return ItemStack.field_190927_a;
            }
            if (index < recipeCount + inputCount ? !this.func_75135_a(stackInSlot, playerStart, playerEnd, true) : (index < machineSlots ? !this.func_75135_a(stackInSlot, playerStart, playerEnd, true) : !this.func_75135_a(stackInSlot, recipeCount, recipeCount + inputCount, false))) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
            }
            this.func_75142_b();
            return copy;
        }

        @Override
        public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
            ItemStack returned = super.func_184996_a(slotId, dragType, clickType, player);
            this.func_75142_b();
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71110_a((Container)this, this.field_75153_a);
            }
            return returned;
        }
    }

    public static enum ContainerMode {
        CONTAINER_ITEMS_TO_OUTPUT,
        CONTAINER_ITEMS_STAY_IN_INPUT;

    }

    public static enum SideMode {
        NONE,
        INPUT,
        OUTPUT,
        INOUT;

    }
}

