/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolidWood;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.modcompat.XUTConTextureBase;
import com.rwtema.extrautils2.modcompat.XUTConTextureMagicWood;
import com.rwtema.extrautils2.modcompat.XUTinkerMaterial;
import com.rwtema.extrautils2.modcompat.XUTrait;
import com.rwtema.extrautils2.utils.datastructures.IntPair;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class TinkersIntegration {
    static List<XUTinkerMaterial> xuTinkerMaterials;

    public static void createObjects() {
        xuTinkerMaterials = ImmutableList.of((Object)new XUTinkerMaterial("xu_magical_wood", -131160, "blockMagicalWood", (Supplier)BlockDecorativeSolidWood.DecorStates.magical_wood, false){

            @Override
            public void addTraits() {
                this.addTrait((ITrait)new XUTrait.TraitMagicalModifiers(), null);
                this.addTraitToAllParts((ITrait)new XUTrait.TraitBrittle());
            }

            @Override
            public void addStats(List<IMaterialStats> stats) {
                stats.add((IMaterialStats)new HeadMaterialStats(35, 2.0f, 2.0f, 0));
                stats.add((IMaterialStats)new HandleMaterialStats(1.0f, 25));
                stats.add((IMaterialStats)new ExtraMaterialStats(15));
                stats.add((IMaterialStats)new BowMaterialStats(1.0f, 1.0f, 0.0f));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite createTexture(ResourceLocation baseTexture, String location) {
                return new XUTConTextureMagicWood(baseTexture, location);
            }
        }, (Object)new XUTinkerMaterial("xu_evil_metal", -131160, "EvilMetal", (Supplier)ItemIngredients.Type.EVIL_INFUSED_INGOT, true){

            @Override
            public void addTraits() {
                this.addTrait((ITrait)new XUTrait.TraitWithering(), "head");
            }

            @Override
            public void addStats(List<IMaterialStats> stats) {
                stats.add((IMaterialStats)new HeadMaterialStats(666, 13.0f, 13.0f, 4));
                stats.add((IMaterialStats)new HandleMaterialStats(1.0f, 0));
                stats.add((IMaterialStats)new ExtraMaterialStats(66));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite createTexture(ResourceLocation baseTexture, String location) {
                return new XUTConTextureBase(baseTexture, location){

                    @Override
                    protected void preProcess(int[] datum, Map<IntPair, Integer> valueOverride, Map<IntPair, Integer> colorOverride) {
                        int[] edgeDist = this.getEdgeDist(datum);
                        this.addOverrides(colorOverride, 1.filter(edgeDist, 2), -16777216);
                        this.addOverrides(valueOverride, 1.and(1.invert(1.filter(edgeDist, 0)), 1.invert(1.or(1.filter(edgeDist, 2), 1.filter(edgeDist, 1)))), -16777216);
                        this.addColorPalette(-2039177, -65555);
                    }
                };
            }

            @Override
            protected int[] createPalette() {
                return new int[]{-34304, -131160, -65555};
            }
        }, (Object)new XUTinkerMaterial("xu_enchanted_metal", -4197792, "EnchantedMetal", (Supplier)ItemIngredients.Type.ENCHANTED_INGOT, true){

            @Override
            public void addTraits() {
                this.addTrait((ITrait)new XUTrait.TraitExperience());
            }

            @Override
            public void addStats(List<IMaterialStats> stats) {
                stats.add((IMaterialStats)new HeadMaterialStats(350, 7.0f, 3.5f, 1));
                stats.add((IMaterialStats)new HandleMaterialStats(1.1f, 20));
                stats.add((IMaterialStats)new ExtraMaterialStats(80));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite createTexture(ResourceLocation baseTexture, String location) {
                return new XUTConTextureBase(baseTexture, location){

                    @Override
                    protected void preProcess(int[] datum, Map<IntPair, Integer> valueOverride, Map<IntPair, Integer> colorOverride) {
                        int[] edgeDist = this.getEdgeDist(datum);
                        this.addOverrides(colorOverride, 1.filter(edgeDist, 1), -13096958);
                        this.addOverrides(colorOverride, 1.filter(edgeDist, 2), -5053350);
                        this.addOverrides(colorOverride, 1.filter(edgeDist, 3), -15053786);
                        this.addOverrides(colorOverride, 1.filter(edgeDist, 4), -5707667);
                        this.addColorPalette(-15053530, -9979298);
                    }
                };
            }

            @Override
            protected int[] createPalette() {
                return new int[]{-15053786, -2562982, -9916350, -3539055, -5048473, -655473};
            }
        }, (Object)new XUTinkerMaterial("xu_demonic_metal", -6079744, "DemonicMetal", (Supplier)ItemIngredients.Type.DEMON_INGOT, true){

            @Override
            public void addStats(List<IMaterialStats> stats) {
                stats.add((IMaterialStats)new HeadMaterialStats(80, 0.5f, 11.1f, 1));
                stats.add((IMaterialStats)new HandleMaterialStats(0.25f, 100));
                stats.add((IMaterialStats)new ExtraMaterialStats(20));
                stats.add((IMaterialStats)new BowMaterialStats(0.7f, 1.1f, 4.0f));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite createTexture(ResourceLocation baseTexture, String location) {
                return new XUTConTextureBase(baseTexture, location){

                    @Override
                    protected void preProcess(int[] datum, Map<IntPair, Integer> valueOverride, Map<IntPair, Integer> colorOverride) {
                        int[] edgeDist = this.getEdgeDist(datum);
                        boolean[] edges = 1.filter(edgeDist, 1);
                        this.addOverrides(colorOverride, edges, 0x550B00);
                        this.addColorPalette(-22016, -7142400, -4061440, -2619648, -1045760);
                    }
                };
            }

            @Override
            public void addTraits() {
                this.addTrait((ITrait)new XUTrait.TraitChatty(), "head");
            }

            @Override
            protected int[] createPalette() {
                return new int[]{-12449024, -7142400, -4061440, -34304, -2619648, -1045760, -62720};
            }
        });
    }

    public static void doRegister() {
        boolean useFluids = TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
        for (XUTinkerMaterial mat : xuTinkerMaterials) {
            ItemStack stack;
            if (useFluids && mat.fluid != null) {
                FluidRegistry.registerFluid((Fluid)mat.fluid);
                if (!FluidRegistry.getBucketFluids().contains(mat.fluid)) {
                    FluidRegistry.addBucketForFluid((Fluid)mat.fluid);
                }
            }
            if (mat.representativeStack != null && StackHelper.isNonNull(stack = mat.representativeStack.get())) {
                mat.material.setRepresentativeItem(stack.func_77946_l());
            }
            TinkerRegistry.addMaterial((Material)mat.material);
            mat.registerTraits();
            for (IMaterialStats stat : mat.getStats()) {
                TinkerRegistry.addMaterialStats((Material)mat.material, (IMaterialStats)stat);
            }
            if (useFluids && mat.fluid != null) {
                mat.material.setFluid(mat.fluid);
                mat.material.setCastable(true);
                continue;
            }
            mat.material.setCraftable(true);
        }
    }

    public static void init() {
        for (XUTinkerMaterial mat : xuTinkerMaterials) {
            if (mat.fluid != null && mat.oreDicSuffix != null) {
                TinkerSmeltery.registerOredictMeltingCasting((Fluid)mat.fluid, (String)mat.oreDicSuffix);
            } else if (mat.oreDicSuffix != null) {
                mat.material.addItem(mat.oreDicSuffix, 1, 144);
            }
            TinkerSmeltery.registerToolpartMeltingCasting((Material)mat.material);
        }
    }
}

