/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft;

import com.google.common.collect.MapMaker;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.commands.Command;
import org.minimallycorrect.tickprofiler.minecraft.commands.DumpCommand;
import org.minimallycorrect.tickprofiler.minecraft.commands.ProfileCommand;
import org.minimallycorrect.tickprofiler.minecraft.commands.TPSCommand;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

@Mod(modid="tickprofiler", name="TickProfiler", acceptableRemoteVersions="*", version="1.12-0.0.10", acceptedMinecraftVersions="[1.12.2]")
public class TickProfiler {
    private static final Set<World> profilingWorlds = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    @Mod.Instance(value="tickprofiler")
    public static TickProfiler instance;
    public static long tickTime;
    public static long lastTickTime;
    public static long tickCount;
    public boolean requireOpForProfileCommand = true;
    public boolean requireOpForDumpCommand = true;
    public boolean requireOpForTPSCommand = false;
    private int profilingInterval = 0;
    private String profilingFileName = "world/computer/<computer id>/profile.txt";
    private boolean profilingJson = false;

    public static boolean shouldProfile(World w) {
        return profilingWorlds.contains(w);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        lastTickTime = System.nanoTime();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ProfilingScheduledTickHandler(this.profilingInterval, new File(".", this.profilingFileName), this.profilingJson));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        String GENERAL = "general";
        ProfileCommand.name = config.get(GENERAL, "profileCommandName", ProfileCommand.name, "Name of the command to be used for profiling reports.").getString();
        DumpCommand.name = config.get(GENERAL, "dumpCommandName", DumpCommand.name, "Name of the command to be used for dumping block data.").getString();
        TPSCommand.name = config.get(GENERAL, "tpsCommandName", TPSCommand.name, "Name of the command to be used for TPS reports.").getString();
        this.requireOpForProfileCommand = config.get(GENERAL, "requireOpForProfileCommand", this.requireOpForProfileCommand, "If a player must be opped to use /profile").getBoolean(this.requireOpForProfileCommand);
        this.requireOpForTPSCommand = config.get(GENERAL, "requireOpForTPSCommand", this.requireOpForTPSCommand, "If a player must be opped to use /tps").getBoolean(this.requireOpForTPSCommand);
        this.requireOpForDumpCommand = config.get(GENERAL, "requireOpForProfileCommand", this.requireOpForDumpCommand, "If a player must be opped to use /dump").getBoolean(this.requireOpForDumpCommand);
        this.profilingInterval = config.get(GENERAL, "profilingInterval", this.profilingInterval, "Interval, in minutes, to record profiling information to disk. 0 = never. Recommended >= 2.").getInt();
        this.profilingFileName = config.get(GENERAL, "profilingFileName", this.profilingFileName, "Location to store profiling information to, relative to the server folder. For example, why not store it in a computercraft computer's folder?").getString();
        this.profilingJson = config.get(GENERAL, "profilingJson", this.profilingJson, "Whether to write periodic profiling in JSON format").getBoolean(this.profilingJson);
        config.save();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ServerCommandManager serverCommandManager = (ServerCommandManager)event.getServer().func_71187_D();
        serverCommandManager.func_71560_a((ICommand)new ProfileCommand());
        serverCommandManager.func_71560_a((ICommand)new DumpCommand());
        serverCommandManager.func_71560_a((ICommand)new TPSCommand());
    }

    public synchronized void hookProfiler(World world) {
        if (world.field_72995_K) {
            Log.error("World " + Log.name(world) + " seems to be a client world", new Throwable());
        }
        profilingWorlds.add(world);
    }

    public synchronized void unhookProfiler(World world) {
        if (world.field_72995_K) {
            Log.error("World " + Log.name(world) + " seems to be a client world", new Throwable());
        }
        if (!profilingWorlds.remove(world)) {
            throw new IllegalStateException("Not already profiling");
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Item usedItemType;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ItemStack usedItem = entityPlayer.func_184607_cu();
        if (usedItem != null && usedItem != ItemStack.field_190927_a && (usedItemType = usedItem.func_77973_b()) == Items.field_151113_aN && (!this.requireOpForDumpCommand || entityPlayer.func_70003_b(4, "dump"))) {
            Command.sendChat((ICommandSender)entityPlayer, DumpCommand.dump(new TableFormatter((ICommandSender)entityPlayer), entityPlayer.field_70170_p, event.getPos(), 35).toString());
            event.setCanceled(true);
        }
    }

    static {
        tickTime = 20L;
        tickCount = 0L;
    }

    public static class ProfilingScheduledTickHandler {
        private final int profilingInterval;
        private final File profilingFile;
        private final boolean json;
        private int counter = 0;

        public ProfilingScheduledTickHandler(int profilingInterval, File profilingFile, boolean json) {
            this.profilingInterval = profilingInterval;
            this.profilingFile = profilingFile;
            this.json = json;
        }

        @SubscribeEvent
        public void tick(TickEvent.ServerTickEvent tick) {
            if (tick.phase != TickEvent.Phase.START) {
                return;
            }
            long time = System.nanoTime();
            long thisTickTime = time - lastTickTime;
            lastTickTime = time;
            tickTime = (tickTime * 19L + thisTickTime) / 20L;
            ++tickCount;
            int profilingInterval = this.profilingInterval;
            if (profilingInterval <= 0 || this.counter++ % (profilingInterval * 60 * 20) != 0) {
                return;
            }
            throw new UnsupportedOperationException("Periodic JSON profiling not currently supported - TODO - fix");
        }
    }
}

