/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.FermenterRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Fermenter")
@ModOnly(value="forestry")
@ZenRegister
public class Fermenter {
    public static final String name = "Forestry Fermenter";
    public static final String nameFuel = "Forestry Fermenter (Fuel)";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add((IFermenterRecipe)new FermenterRecipe(InputHelper.toStack((IItemStack)resource), fermentationValue, fluidOutputModifier, InputHelper.getFluid((ILiquidStack)fluidOutput), InputHelper.toFluid((ILiquidStack)fluidInput))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(input));
    }

    private static boolean isInOreDictOreIsThatOreDict(IIngredient ingredient, String oredict) {
        if (ingredient instanceof IOreDictEntry) {
            return Objects.equals(oredict, ((IOreDictEntry)ingredient).getName());
        }
        if (ingredient instanceof IItemStack) {
            for (IOreDictEntry iOreDictEntry : ((IItemStack)ingredient).getOres()) {
                if (!iOreDictEntry.getName().equals(oredict)) continue;
                return true;
            }
        }
        return false;
    }

    @ZenMethod
    public static void addFuel(IItemStack item, int fermentPerCycle, int burnDuration) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFuel(new FermenterFuel(InputHelper.toStack((IItemStack)item), fermentPerCycle, burnDuration)));
    }

    @ZenMethod
    public static void removeFuel(IIngredient fermenterItem) {
        HashMap<ItemStack, FermenterFuel> fuelItems = new HashMap<ItemStack, FermenterFuel>();
        for (Map.Entry fuelItem : FuelManager.fermenterFuel.entrySet()) {
            if (fuelItem == null || !StackHelper.matches((IIngredient)fermenterItem, (IItemStack)InputHelper.toIItemStack((ItemStack)((FermenterFuel)fuelItem.getValue()).getItem()))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (FermenterFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            ModTweaker.LATE_REMOVALS.add((IAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, fermenterItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, FermenterFuel> {
        public RemoveFuel(Map<ItemStack, FermenterFuel> recipes) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel, recipes);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, FermenterFuel> {
        public AddFuel(FermenterFuel fuelEntry) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel);
            this.recipes.put(fuelEntry.getItem(), fuelEntry);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class Remove
    extends BaseRemoveForestry<IFermenterRecipe> {
        private IIngredient input;

        public Remove(IIngredient input) {
            super(Fermenter.name, (ICraftingProvider)RecipeManagers.fermenterManager);
            this.input = input;
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.input);
        }

        public boolean checkIsRecipe(IFermenterRecipe recipe) {
            if (Fermenter.isInOreDictOreIsThatOreDict(this.input, recipe.getResourceOreName())) {
                return true;
            }
            if (StackHelper.matches((IIngredient)this.input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getResource()))) {
                return true;
            }
            return StackHelper.matches((IIngredient)this.input, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)recipe.getFluidResource()));
        }
    }

    private static class Add
    extends BaseAddForestry<IFermenterRecipe> {
        public Add(IFermenterRecipe recipe) {
            super(Fermenter.name, (ICraftingProvider)RecipeManagers.fermenterManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return ((IFermenterRecipe)this.recipe).getOutput().getName();
        }
    }
}

