/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.lexicon;

import com.blamejared.compat.botania.BotaniaHelper;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;

public class AddRecipeMapping
implements IAction {
    private IItemStack stack;
    private String entry;
    private int page;

    public AddRecipeMapping(IItemStack stack, String entry, int page) {
        this.stack = stack;
        this.entry = entry;
        this.page = page;
    }

    public void apply() {
        LexiconEntry lexiconentry = BotaniaHelper.findEntry(this.entry);
        if (LexiconRecipeMappings.getDataForStack((ItemStack)InputHelper.toStack((IItemStack)this.stack)) != null) {
            CraftTweakerAPI.getLogger().logError("There is already a recipe mapping for " + this.stack);
            return;
        }
        if (lexiconentry == null) {
            CraftTweakerAPI.getLogger().logError("Cannot find lexicon entry " + this.entry);
            return;
        }
        if (lexiconentry.pages.size() < this.page) {
            CraftTweakerAPI.getLogger().logError("Not enough pages in " + this.entry);
            return;
        }
        LexiconRecipeMappings.map((ItemStack)InputHelper.toStack((IItemStack)this.stack), (LexiconEntry)lexiconentry, (int)this.page);
    }

    public String describe() {
        return "Adding Lexicon Recipe Lookup: " + LogHelper.getStackDescription((IIngredient)this.stack);
    }
}

