/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.api.core.ISecurable;
import cofh.core.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SecurityHelper {
    public static final GameProfile UNKNOWN_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static UUID cachedId;

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uuid) {
        return uuid == null || uuid.version() == 4 && uuid.variant() == 0;
    }

    public static UUID getID(EntityPlayer player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && server.func_71278_l()) {
            return player.func_146103_bH().getId();
        }
        return SecurityHelper.getClientId(player);
    }

    private static UUID getClientId(EntityPlayer player) {
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return player.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound tag, ISecurable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74757_a("Secure", true);
        tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
        tag.func_74778_a("OwnerUUID", tile.getOwner().getId().toString());
        tag.func_74778_a("Owner", tile.getOwner().getName());
        return tag;
    }

    public static void addOwnerInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            boolean hasUUID = stack.func_77978_p().func_74764_b("OwnerUUID");
            if (!stack.func_77978_p().func_74764_b("Owner") && !hasUUID) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (hasUUID && stack.func_77978_p().func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + stack.func_77978_p().func_74779_i("Owner") + " \u0378");
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            String accessString = "";
            switch (ISecurable.AccessMode.values()[stack.func_77978_p().func_74771_c("Access")]) {
                case PUBLIC: {
                    accessString = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case FRIENDS: {
                    accessString = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case TEAM: {
                    accessString = StringHelper.localize("info.cofh.accessTeam");
                    break;
                }
                case PRIVATE: {
                    accessString = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + accessString);
        }
    }

    public static boolean isSecure(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("Secure", true);
        stack.func_77978_p().func_74774_a("Access", (byte)0);
        return stack;
    }

    public static ItemStack removeSecure(ItemStack stack) {
        if (!SecurityHelper.isSecure(stack)) {
            return stack;
        }
        stack.func_77978_p().func_82580_o("Secure");
        stack.func_77978_p().func_82580_o("Access");
        stack.func_77978_p().func_82580_o("OwnerUUID");
        stack.func_77978_p().func_82580_o("Owner");
        if (stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
        return stack;
    }

    public static boolean setAccess(ItemStack stack, ISecurable.AccessMode access) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.func_77978_p().func_74774_a("Access", (byte)access.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        return !stack.func_77942_o() ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[stack.func_77978_p().func_74771_c("Access")];
    }

    public static boolean setOwner(ItemStack stack, GameProfile name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.func_77983_a("OwnerUUID", (NBTBase)new NBTTagString(name.getId().toString()));
        stack.func_77983_a("Owner", (NBTBase)new NBTTagString(name.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            String uuid = nbt.func_74779_i("OwnerUUID");
            String name = nbt.func_74779_i("Owner");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_187473_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (String)name)), name);
            }
        }
        return UNKNOWN_GAME_PROFILE;
    }

    public static GameProfile getProfile(UUID uuid, String name) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        GameProfile owner = server.func_152358_ax().func_152652_a(uuid);
        if (owner == null) {
            GameProfile temp = new GameProfile(uuid, name);
            owner = server.func_147130_as().fillProfileProperties(temp, true);
            if (owner != temp) {
                server.func_152358_ax().func_152649_a(owner);
            }
        }
        return owner;
    }

    public static String getOwnerName(ItemStack stack) {
        boolean hasUUID;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !(hasUUID = nbt.func_74764_b("OwnerUUID")) && !nbt.func_74764_b("Owner")) {
            return "[None]";
        }
        return hasUUID ? stack.func_77978_p().func_74779_i("Owner") : StringHelper.localize("info.cofh.anotherplayer");
    }
}

