/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.ingredients;

import java.awt.Color;
import java.util.Collections;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.util.CommandUtilServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class DebugIngredientHelper
implements IIngredientHelper<DebugIngredient> {
    @Override
    @Nullable
    public DebugIngredient getMatch(Iterable<DebugIngredient> ingredients, DebugIngredient ingredientToMatch) {
        for (DebugIngredient debugIngredient : ingredients) {
            if (debugIngredient.getNumber() != ingredientToMatch.getNumber()) continue;
            return debugIngredient;
        }
        return null;
    }

    @Override
    public String getDisplayName(DebugIngredient ingredient) {
        return "JEI Debug Item #" + ingredient.getNumber();
    }

    @Override
    public String getUniqueId(DebugIngredient ingredient) {
        return "JEI_debug_" + ingredient.getNumber();
    }

    @Override
    public String getWildcardId(DebugIngredient ingredient) {
        return this.getUniqueId(ingredient);
    }

    @Override
    public String getModId(DebugIngredient ingredient) {
        return "jei";
    }

    @Override
    public Iterable<Color> getColors(DebugIngredient ingredient) {
        return Collections.emptyList();
    }

    @Override
    public String getResourceId(DebugIngredient ingredient) {
        return "debug_" + ingredient.getNumber();
    }

    @Override
    public ItemStack getCheatItemStack(DebugIngredient ingredient) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            CommandUtilServer.writeChatMessage((EntityPlayer)player, "Debug ingredients cannot be cheated", TextFormatting.RED);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public DebugIngredient copyIngredient(DebugIngredient ingredient) {
        return ingredient.copy();
    }

    @Override
    public String getErrorInfo(@Nullable DebugIngredient ingredient) {
        if (ingredient == null) {
            return "debug ingredient: null";
        }
        return this.getDisplayName(ingredient);
    }

    @Override
    public String getErrorInfoMinimal(@Nullable DebugIngredient ingredient) {
        if (ingredient == null) {
            return "debug ingredient: null";
        }
        return this.getDisplayName(ingredient);
    }
}

