/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class ChargeUtils {
    public static boolean isIC2Chargeable(ItemStack itemStack) {
        return ElectricItem.manager.charge(itemStack, 2.147483647E9, 4, true, true) > 0.0;
    }

    public static boolean isIC2Dischargeable(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, 2.147483647E9, 4, true, true, true) > 0.0;
    }

    public static void discharge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ItemStack stack = inv.func_70301_a(slotID);
        if (!stack.func_190926_b() && storer.getEnergy() < storer.getMaxEnergy()) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(stack, storer.getMaxEnergy() - storer.getEnergy()));
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)stack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                long needed = TeslaIntegration.toTesla(storer.getMaxEnergy() - storer.getEnergy());
                storer.setEnergy(storer.getEnergy() + TeslaIntegration.fromTesla(producer.takePower(needed, false)));
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canExtract()) {
                    int needed = ForgeEnergyIntegration.toForge(storer.getMaxEnergy() - storer.getEnergy());
                    storer.setEnergy(storer.getEnergy() + ForgeEnergyIntegration.fromForge(storage.extractEnergy(needed, false)));
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int needed = RFIntegration.toRF(storer.getMaxEnergy() - storer.getEnergy());
                storer.setEnergy(storer.getEnergy() + RFIntegration.fromRF(item.extractEnergy(stack, needed, false)));
            } else if (MekanismUtils.useIC2() && ChargeUtils.isIC2Dischargeable(stack)) {
                double gain = IC2Integration.fromEU(ElectricItem.manager.discharge(stack, IC2Integration.toEU(storer.getMaxEnergy() - storer.getEnergy()), 4, true, true, false));
                storer.setEnergy(storer.getEnergy() + gain);
            } else if (stack.func_77973_b() == Items.field_151137_ax && storer.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val() <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val());
                stack.func_190918_g(1);
            }
        }
    }

    public static void charge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ChargeUtils.charge(inv.func_70301_a(slotID), storer);
    }

    public static void charge(ItemStack stack, IStrictEnergyStorage storer) {
        if (!stack.func_190926_b() && storer.getEnergy() > 0.0) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(stack, storer.getEnergy()));
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                long stored = TeslaIntegration.toTesla(storer.getEnergy());
                storer.setEnergy(storer.getEnergy() - TeslaIntegration.fromTesla(consumer.givePower(stored, false)));
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canReceive()) {
                    int stored = ForgeEnergyIntegration.toForge(storer.getEnergy());
                    storer.setEnergy(storer.getEnergy() - ForgeEnergyIntegration.fromForge(storage.receiveEnergy(stored, false)));
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int toTransfer = RFIntegration.toRF(storer.getEnergy());
                storer.setEnergy(storer.getEnergy() - RFIntegration.fromRF(item.receiveEnergy(stack, toTransfer, false)));
            } else if (MekanismUtils.useIC2() && ChargeUtils.isIC2Chargeable(stack)) {
                double sent = IC2Integration.fromEU(ElectricItem.manager.charge(stack, IC2Integration.toEU(storer.getEnergy()), 4, true, false));
                storer.setEnergy(storer.getEnergy() - sent);
            }
        }
    }

    public static boolean canBeDischarged(ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canSend(itemstack) && ((IEnergizedItem)itemstack.func_77973_b()).getEnergy(itemstack) > 0.0) {
            return true;
        }
        if (MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null) && ((ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)).takePower(1L, true) > 0L) {
            return true;
        }
        if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).extractEnergy(itemstack, 1, true) != 0) {
            return true;
        }
        if (MekanismUtils.useIC2() && ElectricItem.manager.discharge(itemstack, 1.0, 0, true, true, true) > 0.0) {
            return true;
        }
        return itemstack.func_77973_b() == Items.field_151137_ax;
    }

    public static boolean canBeCharged(ItemStack itemstack) {
        IEnergizedItem energizedItem;
        if (itemstack.func_77973_b() instanceof IEnergizedItem && (energizedItem = (IEnergizedItem)itemstack.func_77973_b()).canReceive(itemstack) && energizedItem.getMaxEnergy(itemstack) < energizedItem.getEnergy(itemstack)) {
            return true;
        }
        if (MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null) && ((ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)).givePower(1L, true) > 0L) {
            return true;
        }
        if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, 1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useIC2()) {
            return ChargeUtils.isIC2Chargeable(itemstack);
        }
        return false;
    }

    public static boolean canBeOutputted(ItemStack itemstack, boolean chargeSlot) {
        IElectricItemManager manager;
        if (itemstack.func_77973_b() instanceof IEnergizedItem) {
            IEnergizedItem energized = (IEnergizedItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energized.getEnergy(itemstack) == energized.getMaxEnergy(itemstack);
            }
            return energized.getEnergy(itemstack) == 0.0;
        }
        if (MekanismUtils.useTesla()) {
            if (chargeSlot && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                return consumer.givePower(1L, true) == 0L;
            }
            if (!chargeSlot && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                return producer.takePower(1L, true) == 0L;
            }
        }
        if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
            if (chargeSlot) {
                return !storage.canReceive() || storage.receiveEnergy(1, true) == 0;
            }
            return !storage.canExtract() || storage.extractEnergy(1, true) == 0;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energyContainer.receiveEnergy(itemstack, 1, true) == 0;
            }
            return energyContainer.extractEnergy(itemstack, 1, true) == 0;
        }
        if (MekanismUtils.useIC2() && (ChargeUtils.isIC2Chargeable(itemstack) || ChargeUtils.isIC2Dischargeable(itemstack)) && (manager = ElectricItem.manager) != null) {
            if (chargeSlot) {
                return manager.charge(itemstack, 1.0, 3, true, true) == 0.0;
            }
            return manager.discharge(itemstack, 1.0, 3, true, true, true) == 0.0;
        }
        return true;
    }
}

