/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.HashSet;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.base.target.EnergyAcceptorTarget;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class CableUtils {
    public static boolean isCable(TileEntity tileEntity) {
        IGridTransmitter gridTransmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null);
        if (gridTransmitter != null) {
            return TransmissionType.checkTransmissionType(gridTransmitter, TransmissionType.ENERGY);
        }
        return false;
    }

    public static boolean isValidAcceptorOnSide(TileEntity cableEntity, TileEntity tile, EnumFacing side) {
        if (tile == null || CableUtils.isCable(tile)) {
            return false;
        }
        return CableUtils.isAcceptor(cableEntity, tile, side) || CableUtils.isOutputter(cableEntity, tile, side) || MekanismUtils.useRF() && tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.func_176734_d()) || MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityEnergy.ENERGY, side.func_176734_d());
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        return CableUtils.getConnectedOutputters(tileEntity, tileEntity.func_174877_v(), tileEntity.func_145831_w());
    }

    public static TileEntity[] getConnectedOutputters(BlockPos pos, World world) {
        return CableUtils.getConnectedOutputters(MekanismUtils.getTileEntity(world, pos), pos, world);
    }

    public static TileEntity[] getConnectedOutputters(TileEntity source, BlockPos pos, World world) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (EnumFacing orientation : EnumFacing.field_82609_l) {
            TileEntity outputter = MekanismUtils.getTileEntity(world, pos.func_177972_a(orientation));
            if (!CableUtils.isOutputter(source, outputter, orientation)) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean isOutputter(TileEntity source, TileEntity tileEntity, EnumFacing side) {
        IEnergyStorage forgeStorage;
        if (tileEntity == null) {
            return false;
        }
        EnumFacing opposite = side.func_176734_d();
        IStrictEnergyOutputter outputter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_OUTPUTTER_CAPABILITY, opposite);
        if (outputter != null && outputter.canOutputEnergy(opposite)) {
            return true;
        }
        if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_PRODUCER_CAPABILITY, opposite)) {
            return true;
        }
        if (MekanismUtils.useForge() && (forgeStorage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, opposite)) != null) {
            return forgeStorage.canExtract();
        }
        if (MekanismUtils.useRF() && tileEntity instanceof IEnergyProvider && ((IEnergyConnection)tileEntity).canConnectEnergy(opposite)) {
            return true;
        }
        return MekanismUtils.useIC2() && IC2Integration.isOutputter(tileEntity, side);
    }

    public static boolean isAcceptor(TileEntity source, TileEntity tileEntity, EnumFacing side) {
        IEnergyStorage energyStorage;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        IStrictEnergyAcceptor strictEnergyAcceptor = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side.func_176734_d());
        if (strictEnergyAcceptor != null) {
            return strictEnergyAcceptor.canReceiveEnergy(side.func_176734_d());
        }
        if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        if (MekanismUtils.useForge() && (energyStorage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())) != null) {
            return energyStorage.canReceive();
        }
        if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)tileEntity).canConnectEnergy(side.func_176734_d());
        }
        return MekanismUtils.useIC2() && IC2Integration.isAcceptor(tileEntity, side);
    }

    public static void emit(IEnergyWrapper emitter) {
        double energyToSend;
        TileEntity tileEntity = (TileEntity)emitter;
        if (!tileEntity.func_145831_w().field_72995_K && MekanismUtils.canFunction(tileEntity) && (energyToSend = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            Coord4D coord = Coord4D.get(tileEntity);
            EnergyAcceptorTarget target = new EnergyAcceptorTarget();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                EnumFacing opposite;
                EnergyAcceptorWrapper acceptor;
                TileEntity tile;
                if (!emitter.sideIsOutput(side) || tileEntity instanceof TileEntityEnergyCube && side == EnumFacing.DOWN && (tile = MekanismUtils.getTileEntitySafe((IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177982_a(0, -1, 0))) instanceof TileEntityEnergyCube || tileEntity instanceof TileEntityEnergyCube && side == EnumFacing.UP && (tile = MekanismUtils.getTileEntitySafe((IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177982_a(0, 1, 0))) instanceof TileEntityEnergyCube || (tile = coord.offset(side).getTileEntity((IBlockAccess)tileEntity.func_145831_w())) == null || !CableUtils.isValidAcceptorOnSide(tileEntity, tile, side) && !CableUtils.isCable(tile) || (acceptor = EnergyAcceptorWrapper.get(tile, opposite = side.func_176734_d())) == null || !acceptor.canReceiveEnergy(opposite) || !acceptor.needsEnergy(opposite)) continue;
                target.addHandler(opposite, acceptor);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers > 0) {
                HashSet<EnergyAcceptorTarget> targets = new HashSet<EnergyAcceptorTarget>();
                targets.add(target);
                double sent = EmitUtils.sendToAcceptors(targets, curHandlers, energyToSend);
                if (emitter instanceof TileEntityInductionPort) {
                    ((TileEntityInductionPort)emitter).removeEnergy(sent, false);
                } else {
                    emitter.setEnergy(emitter.getEnergy() - sent);
                }
            }
        }
    }
}

