/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.EnumMap;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.options.DoubleOption;
import mekanism.common.config.options.IntOption;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.BinTier;
import mekanism.common.tier.CableTier;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tier.InductionCellTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tier.TubeTier;

public class TierConfig {
    public final DoubleOption EnergyCubeMaxEnergy;
    public final DoubleOption EnergyCubeOutput;
    public final DoubleOption InductionCellMaxEnergy;
    public final IntOption CableCapacity;
    public final IntOption PipeCapacity;
    public final IntOption PipePullAmount;
    public final IntOption TubeCapacity;
    public final IntOption TubePullAmount;
    public final IntOption TransporterPullAmount;
    public final IntOption TransporterSpeed;
    public final DoubleOption ConductorInverseConduction;
    public final DoubleOption ConductorHeatCapacity;
    public final DoubleOption ConductorConductionInsulation;
    public final IntOption FluidTankStorage;
    public final IntOption FluidTankOutput;
    public final IntOption GasTankStorage;
    public final IntOption GasTankOutput;
    public final IntOption BinStorage;

    public static EnumMap<BaseTier, TierConfig> create(BaseConfig baseConfig) {
        EnumMap<BaseTier, TierConfig> map = new EnumMap<BaseTier, TierConfig>(BaseTier.class);
        for (BaseTier baseTier : BaseTier.values()) {
            map.put(baseTier, new TierConfig(baseConfig, baseTier));
        }
        return map;
    }

    private TierConfig(BaseConfig baseConfig, BaseTier tier) {
        String name = tier.getSimpleName();
        this.EnergyCubeMaxEnergy = new DoubleOption(baseConfig, "tier", name + "EnergyCubeMaxEnergy", EnergyCubeTier.values()[tier.ordinal()].getBaseMaxEnergy(), "Maximum number of Joules a " + name + " Battery can store.");
        this.EnergyCubeOutput = new DoubleOption(baseConfig, "tier", name + "EnergyCubeOutput", EnergyCubeTier.values()[tier.ordinal()].getBaseOutput(), "Output rate in Joules of a " + name + " Battery.");
        this.FluidTankStorage = new IntOption(baseConfig, "tier", name + "FluidTankStorage", FluidTankTier.values()[tier.ordinal()].getBaseStorage(), "Storage size of " + name + " gas tank in mB.");
        this.FluidTankOutput = new IntOption(baseConfig, "tier", name + "FluidTankOutput", FluidTankTier.values()[tier.ordinal()].getBaseOutput(), "Output rate of " + name + " gas tank in mB.");
        this.GasTankStorage = new IntOption(baseConfig, "tier", name + "GasTankStorage", GasTankTier.values()[tier.ordinal()].getBaseStorage(), "Storage size of " + name + " gas tank in mB.");
        this.GasTankOutput = new IntOption(baseConfig, "tier", name + "GasTankOutput", GasTankTier.values()[tier.ordinal()].getBaseOutput(), "Output rate of " + name + " gas tank in mB.");
        this.BinStorage = new IntOption(baseConfig, "tier", name + "BinStorage", BinTier.values()[tier.ordinal()].getBaseStorage(), "The number of items a " + name + " bin can store.");
        if (tier != BaseTier.CREATIVE && tier != BaseTier.ABSURD) {
            this.InductionCellMaxEnergy = new DoubleOption(baseConfig, "tier", name + "InductionCellMaxEnergy", InductionCellTier.values()[tier.ordinal()].getBaseMaxEnergy(), "Maximum number of Joules a " + name + " induction cell can store.");
            this.CableCapacity = new IntOption(baseConfig, "tier", name + "CableCapacity", CableTier.values()[tier.ordinal()].getBaseCapacity(), "Internal buffer in Joules of each " + name + " universal cable.");
            this.PipeCapacity = new IntOption(baseConfig, "tier", name + "PipeCapacity", PipeTier.values()[tier.ordinal()].getBaseCapacity(), "Capacity of " + name + " mechanical pipe in mB.");
            this.PipePullAmount = new IntOption(baseConfig, "tier", name + "PipePullAmount", PipeTier.values()[tier.ordinal()].getBasePull(), "Pump rate of " + name + " mechanical pipe in mB/t.");
            this.TubeCapacity = new IntOption(baseConfig, "tier", name + "TubeCapacity", TubeTier.values()[tier.ordinal()].getBaseCapacity(), "Capacity of " + name + " pressurized tube in mB.");
            this.TubePullAmount = new IntOption(baseConfig, "tier", name + "TubePullAmount", TubeTier.values()[tier.ordinal()].getBasePull(), "Pump rate of " + name + " pressurized tube in mB/t.");
            this.TransporterPullAmount = new IntOption(baseConfig, "tier", name + "TransporterPullAmount", TransporterTier.values()[tier.ordinal()].getBasePull(), "Item throughput rate of " + name + " logistical transporter in items/s.");
            this.TransporterSpeed = new IntOption(baseConfig, "tier", name + "TransporterSpeed", TransporterTier.values()[tier.ordinal()].getBaseSpeed(), "Five times travel speed of " + name + " logistical transporter.");
            this.ConductorInverseConduction = new DoubleOption(baseConfig, "tier", name + "ConductorInverseConduction", ConductorTier.values()[tier.ordinal()].getBaseConduction(), "Conduction value of " + name + " thermodynamic conductor.");
            this.ConductorHeatCapacity = new DoubleOption(baseConfig, "tier", name + "ConductorHeatCapacity", ConductorTier.values()[tier.ordinal()].getBaseHeatCapacity(), "Heat capacity of " + name + " thermodynamic conductor.");
            this.ConductorConductionInsulation = new DoubleOption(baseConfig, "tier", name + "ConductorConductionInsulation", ConductorTier.values()[tier.ordinal()].getBaseConductionInsulation(), "Insulation value of " + name + " thermodynamic conductor.");
        } else {
            this.InductionCellMaxEnergy = null;
            this.CableCapacity = null;
            this.PipeCapacity = null;
            this.PipePullAmount = null;
            this.TubeCapacity = null;
            this.TubePullAmount = null;
            this.TransporterPullAmount = null;
            this.TransporterSpeed = null;
            this.ConductorInverseConduction = null;
            this.ConductorHeatCapacity = null;
            this.ConductorConductionInsulation = null;
        }
    }
}

