/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemCapabilityWrapper
implements ICapabilityProvider {
    protected final ItemStack itemStack;
    private final List<ItemCapability> capabilities = new ArrayList<ItemCapability>();

    public ItemCapabilityWrapper(ItemStack stack, ItemCapability ... caps) {
        this.itemStack = stack;
        for (ItemCapability c : caps) {
            c.wrapper = this;
            this.capabilities.add(c);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        for (ItemCapability cap : this.capabilities) {
            if (!cap.canProcess(capability)) continue;
            return true;
        }
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        for (ItemCapability cap : this.capabilities) {
            if (!cap.canProcess(capability)) continue;
            return (T)cap;
        }
        return null;
    }

    public static abstract class ItemCapability {
        private ItemCapabilityWrapper wrapper;

        public abstract boolean canProcess(Capability<?> var1);

        public ItemStack getStack() {
            return this.wrapper.itemStack;
        }
    }
}

