/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.ColourRGBA;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.grid.FluidNetwork;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RenderMechanicalPipe
extends RenderTransmitterBase<TileEntityMechanicalPipe> {
    private static final int stages = 100;
    private static final double height = 0.45;
    private static final double offset = 0.015;
    private static final Int2ObjectMap<FluidRenderMap<MekanismRenderer.DisplayInteger[]>> cachedLiquids = new Int2ObjectArrayMap(7);

    public static void onStitch() {
        cachedLiquids.clear();
    }

    public void render(TileEntityMechanicalPipe pipe, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        FluidStack fluidStack;
        Fluid fluid;
        float targetScale;
        if (MekanismConfig.current().client.opaqueTransmitters.val()) {
            return;
        }
        if (pipe.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)pipe.getTransmitter().getTransmitterNetwork();
            targetScale = network.fluidScale;
            fluid = network.refFluid;
            fluidStack = network.buffer;
        } else {
            targetScale = (float)pipe.buffer.getFluidAmount() / (float)pipe.buffer.getCapacity();
            fluidStack = pipe.getBuffer();
            fluid = fluidStack == null ? null : fluidStack.getFluid();
        }
        pipe.currentScale = (double)Math.abs(pipe.currentScale - targetScale) > 0.01 ? (12.0f * pipe.currentScale + targetScale) / 13.0f : targetScale;
        float scale = Math.min(pipe.currentScale, 1.0f);
        if ((double)scale > 0.01 && fluid != null) {
            MekanismRenderer.GlowInfo glowInfo;
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            if (fluidStack != null) {
                glowInfo = MekanismRenderer.enableGlow(fluidStack);
                MekanismRenderer.color(fluidStack);
            } else {
                glowInfo = MekanismRenderer.enableGlow(fluid);
                MekanismRenderer.color(fluid);
            }
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            boolean gas = fluidStack == null ? fluid.isGaseous() : fluid.isGaseous(fluidStack);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (pipe.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL) {
                    this.renderDisplayLists(this.getListAndRender(side, fluidStack), scale, gas);
                    continue;
                }
                if (pipe.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NONE) continue;
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder worldRenderer = tessellator.func_178180_c();
                if (this.renderFluidInOut(worldRenderer, side, pipe)) {
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.renderDisplayLists(this.getListAndRender(null, fluidStack), scale, gas);
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
    }

    private void renderDisplayLists(MekanismRenderer.DisplayInteger[] displayLists, float scale, boolean gas) {
        if (displayLists != null) {
            if (gas) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                displayLists[99].render();
                MekanismRenderer.resetColor();
            } else {
                displayLists[Math.max(3, (int)(scale * 99.0f))].render();
            }
        }
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(EnumFacing side, FluidStack fluid) {
        int sideOrdinal;
        if (fluid == null) {
            return null;
        }
        int n = sideOrdinal = side != null ? side.ordinal() : 6;
        if (cachedLiquids.containsKey(sideOrdinal) && ((FluidRenderMap)((Object)cachedLiquids.get(sideOrdinal))).containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])((FluidRenderMap)((Object)cachedLiquids.get(sideOrdinal))).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (side != null) {
            toReturn.setSideRender(side, false);
            toReturn.setSideRender(side.func_176734_d(), false);
        }
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[100];
        if (cachedLiquids.containsKey(sideOrdinal)) {
            ((FluidRenderMap)((Object)cachedLiquids.get(sideOrdinal))).put(fluid, displays);
        } else {
            FluidRenderMap map = new FluidRenderMap();
            map.put(fluid, displays);
            cachedLiquids.put(sideOrdinal, map);
        }
        for (int i = 0; i < 100; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (sideOrdinal) {
                case 6: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case 0: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 0.265;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case 1: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.235 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case 2: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.265;
                    break;
                }
                case 3: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.735;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 1.0;
                    break;
                }
                case 4: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.265;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case 5: {
                    toReturn.minX = 0.735;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                }
            }
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }

    public boolean renderFluidInOut(BufferBuilder renderer, EnumFacing side, TileEntityMechanicalPipe pipe) {
        if (pipe != null && pipe.getTransmitter() != null && pipe.getTransmitter().getTransmitterNetwork() != null) {
            this.func_147499_a(TextureMap.field_110575_b);
            FluidNetwork fn = (FluidNetwork)pipe.getTransmitter().getTransmitterNetwork();
            TextureAtlasSprite tex = fn.buffer != null ? MekanismRenderer.getFluidTexture(fn.buffer, MekanismRenderer.FluidType.STILL) : MekanismRenderer.getBaseFluidTexture(fn.refFluid, MekanismRenderer.FluidType.STILL);
            int color = fn.buffer != null ? fn.buffer.getFluid().getColor(fn.buffer) : fn.refFluid.getColor();
            ColourRGBA c = new ColourRGBA(1.0, 1.0, 1.0, pipe.currentScale);
            if (color != -1) {
                c.setRGBFromInt(color);
            }
            this.renderTransparency(renderer, tex, this.getModelForSide(pipe, side), c);
            return true;
        }
        return false;
    }
}

