/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;

public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporter> {
    private static final Map<EnumFacing, Map<Integer, MekanismRenderer.DisplayInteger>> cachedOverlays = new EnumMap<EnumFacing, Map<Integer, MekanismRenderer.DisplayInteger>>(EnumFacing.class);
    private static final ResourceLocation transporterBox = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "TransporterBox.png");
    private static TextureAtlasSprite gunpowderIcon;
    private static TextureAtlasSprite torchOffIcon;
    private static TextureAtlasSprite torchOnIcon;
    private final ModelTransporterBox modelBox = new ModelTransporterBox();
    private final EntityItem entityItem = new EntityItem(null);
    private final Render<EntityItem> renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(EntityItem.class);

    public static void onStitch(TextureMap map) {
        cachedOverlays.clear();
        gunpowderIcon = map.getTextureExtry("minecraft:items/gunpowder");
        torchOffIcon = map.getTextureExtry("minecraft:blocks/redstone_torch_off");
        torchOnIcon = map.getTextureExtry("minecraft:blocks/redstone_torch_on");
    }

    public void render(TileEntityLogisticalTransporter transporter, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (MekanismConfig.current().client.opaqueTransmitters.val()) {
            return;
        }
        boolean pushed = false;
        Collection<TransporterStack> inTransit = transporter.getTransmitter().getTransit();
        if (!inTransit.isEmpty()) {
            GlStateManager.func_179094_E();
            pushed = true;
            this.entityItem.func_174873_u();
            this.entityItem.field_70290_d = 0.0f;
            this.entityItem.func_70107_b((double)transporter.func_174877_v().func_177958_n() + 0.5, (double)transporter.func_174877_v().func_177956_o() + 0.5, (double)transporter.func_174877_v().func_177952_p() + 0.5);
            this.entityItem.field_70170_p = transporter.func_145831_w();
            float partial = partialTick * (float)transporter.tier.getSpeed();
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                this.entityItem.func_92058_a(stack.itemStack);
                float[] pos = TransporterUtils.getStackPosition(transporter.getTransmitter(), stack, partial);
                float xShifted = (float)x + pos[0];
                float yShifted = (float)y + pos[1];
                float zShifted = (float)z + pos[2];
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)xShifted, (float)yShifted, (float)zShifted);
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                this.renderer.func_76986_a((Entity)this.entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GlStateManager.func_179121_F();
                if (stack.color == null) continue;
                this.func_147499_a(transporterBox);
                GlStateManager.func_179094_E();
                MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
                GlStateManager.func_179129_p();
                MekanismRenderer.color(stack.color);
                GlStateManager.func_179109_b((float)xShifted, (float)yShifted, (float)zShifted);
                this.modelBox.render(0.0625f);
                MekanismRenderer.resetColor();
                GlStateManager.func_179089_o();
                MekanismRenderer.disableGlow(glowInfo);
                GlStateManager.func_179121_F();
            }
        }
        if (transporter instanceof TileEntityDiversionTransporter) {
            RayTraceResult pos;
            ItemStack itemStack;
            if (!pushed) {
                GlStateManager.func_179094_E();
                pushed = true;
            }
            if (!(itemStack = this.mc.field_71439_g.field_71071_by.func_70448_g()).func_190926_b() && itemStack.func_77973_b() instanceof ItemConfigurator && (pos = this.mc.field_71439_g.func_174822_a(8.0, 1.0f)) != null && pos.field_178784_b != null && pos.func_178782_a().equals((Object)transporter.func_174877_v())) {
                int mode = ((TileEntityDiversionTransporter)transporter).modes[pos.field_178784_b.ordinal()];
                GlStateManager.func_179094_E();
                GlStateManager.func_179089_o();
                GlStateManager.func_179140_f();
                MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179118_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                this.func_147499_a(TextureMap.field_110575_b);
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                int display = this.getOverlayDisplay((EnumFacing)pos.field_178784_b, (int)mode).display;
                GlStateManager.func_179148_o((int)display);
                MekanismRenderer.resetColor();
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                MekanismRenderer.disableGlow(glowInfo);
                GlStateManager.func_179145_e();
                GlStateManager.func_179129_p();
                GlStateManager.func_179121_F();
            }
        }
        if (pushed) {
            GlStateManager.func_179121_F();
        }
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        HashSet<TransportInformation> information = new HashSet<TransportInformation>();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.func_190926_b() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(EnumFacing side, int mode) {
        if (cachedOverlays.containsKey(side) && cachedOverlays.get(side).containsKey(mode)) {
            return cachedOverlays.get(side).get(mode);
        }
        TextureAtlasSprite icon = null;
        switch (mode) {
            case 0: {
                icon = gunpowderIcon;
                break;
            }
            case 1: {
                icon = torchOnIcon;
                break;
            }
            case 2: {
                icon = torchOffIcon;
            }
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(icon);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (cachedOverlays.containsKey(side)) {
            cachedOverlays.get(side).put(mode, display);
        } else {
            HashMap<Integer, MekanismRenderer.DisplayInteger> map = new HashMap<Integer, MekanismRenderer.DisplayInteger>();
            map.put(mode, display);
            cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = new HashedItem(transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TransportInformation) {
                TransportInformation other = (TransportInformation)obj;
                return this.progress == other.progress && this.color == other.color && this.item.equals(other.item);
            }
            return false;
        }
    }
}

