/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.config.TRLProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

final class TRLCategory {
    final String languageKeyPrefix;
    final String languageKey;
    final Class<?> clazz;
    final String comment;
    final String name;
    final List<TRLProperty> properties = new ArrayList<TRLProperty>();
    final Method onReload;
    final Method onReloadClient;

    TRLCategory(String languageKeyPrefix, Class<?> clazz, String comment, String name) {
        this.languageKeyPrefix = languageKeyPrefix;
        this.languageKey = languageKeyPrefix + name;
        this.clazz = clazz;
        this.comment = comment;
        this.name = TRLUtils.MC_VERSION_NUMBER == 8 ? name.toLowerCase(Locale.ENGLISH) : name;
        this.onReload = TRLCategory.getOnReloadMethod(clazz, "onReload");
        this.onReloadClient = TRLCategory.getOnReloadMethod(clazz, "onReloadClient");
    }

    void onReload(boolean client) {
        Method method;
        Method method2 = method = client ? this.onReloadClient : this.onReload;
        if (method != null) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                TRLUtils.crashReport("Failed to reload configuration category", ex);
            }
        }
    }

    ConfigCategory get(Configuration config) {
        String lowerCase;
        boolean hasCategory = config.hasCategory(this.name);
        ConfigCategory category = config.getCategory(this.name);
        if (!hasCategory && config.hasCategory(lowerCase = this.name.toLowerCase(Locale.ENGLISH))) {
            ConfigCategory oldCategory = config.getCategory(lowerCase);
            category.putAll(oldCategory.getValues());
        }
        config.setCategoryComment(this.name, this.comment);
        config.setCategoryLanguageKey(this.name, this.languageKey);
        return category;
    }

    void createPropertyOrder(Configuration config) {
        this.get(config).setPropertyOrder(this.properties.stream().map(property -> property.name).collect(Collectors.toList()));
    }

    String getLanguageKeyPrefix() {
        return this.languageKey + ".";
    }

    private static Method getOnReloadMethod(Class<?> clazz, String name) {
        int modifiers;
        Method onReload = TRLUtils.findMethod(clazz, name, new Class[0]);
        if (!(onReload == null || Modifier.isPublic(modifiers = onReload.getModifiers()) && Modifier.isStatic(modifiers) && onReload.getReturnType() == Void.TYPE)) {
            throw new IllegalArgumentException(name + " must be public static void");
        }
        return onReload;
    }
}

