/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.blocks;

import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import zabi.minecraft.extraalchemy.lib.Log;

public class BrewingStandFire {
    private static final Field FUEL = ReflectionHelper.findField(TileEntityBrewingStand.class, (String)"fuel", (String)"field_184278_m");
    private boolean errored = false;
    private static final ArrayList<Block> validConductors = new ArrayList(3);

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent evt) {
        if (!this.errored && evt.phase.equals((Object)TickEvent.Phase.END) && evt.world.func_82737_E() % 200L == 1L) {
            try {
                ArrayList allTiles = new ArrayList();
                allTiles.addAll(evt.world.field_147482_g);
                allTiles.stream().filter(te -> te instanceof TileEntityBrewingStand).filter(te -> !te.func_145837_r()).filter(te -> BrewingStandFire.isHeatSource(te.func_174877_v().func_177977_b(), te.func_145831_w(), true)).map(te -> (TileEntityBrewingStand)te).forEach(b -> {
                    try {
                        int fuel = FUEL.getInt(b);
                        if (fuel < 20) {
                            FUEL.set(b, fuel + 1);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        ex.printStackTrace();
                        this.errored = true;
                    }
                });
            }
            catch (Exception e) {
                Log.e(e);
                e.printStackTrace();
                this.errored = true;
            }
        }
    }

    private static boolean isHeatSource(BlockPos pos, World world, boolean re) {
        if (re && validConductors.contains(world.func_180495_p(pos).func_177230_c())) {
            return BrewingStandFire.isHeatSource(pos.func_177977_b(), world, false);
        }
        return world.func_180495_p(pos).func_185904_a().equals(Material.field_151581_o);
    }

    static {
        validConductors.add((Block)Blocks.field_150334_T);
        validConductors.add((Block)Blocks.field_150333_U);
    }
}

