/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SectionRef {
    public int chapter;
    public int section;
    public boolean resolvedNames = false;
    public String chapterName;
    public String sectionName;

    public SectionRef(int chapter, int section) {
        this.chapter = chapter;
        this.section = section;
        this.resolvedNames = true;
    }

    public SectionRef(String chapter, @Nullable String sectionName) {
        this.chapterName = chapter;
        this.sectionName = sectionName;
    }

    public static SectionRef fromString(@Nonnull String refString) {
        if (refString.indexOf(58) >= 0) {
            String[] parts = refString.split(":");
            return new SectionRef(parts[0], parts[1]);
        }
        return new SectionRef(refString, null);
    }

    public boolean resolve(BookDocument bookDocument) {
        block6: {
            if (!this.resolvedNames) {
                try {
                    if (!Strings.isNullOrEmpty((String)this.chapterName)) {
                        Integer ch = Ints.tryParse((String)this.chapterName);
                        this.chapter = ch != null ? ch.intValue() : bookDocument.chaptersByName.get(this.chapterName).intValue();
                        if (!Strings.isNullOrEmpty((String)this.sectionName)) {
                            Integer pg = Ints.tryParse((String)this.sectionName);
                            this.section = pg != null ? pg.intValue() : bookDocument.chapters.get((int)this.chapter).sectionsByName.get(this.sectionName).intValue();
                        }
                        break block6;
                    }
                    if (!Strings.isNullOrEmpty((String)this.sectionName)) {
                        SectionRef temp = bookDocument.sectionsByName.get(this.sectionName);
                        temp.resolve(bookDocument);
                        this.chapter = temp.chapter;
                        this.section = temp.section;
                        break block6;
                    }
                    throw new InvalidPageRefException("Invalid format: missing section and chapter");
                }
                catch (Exception e) {
                    String ref_string = (Strings.isNullOrEmpty((String)this.chapterName) ? "<none>" : this.chapterName) + ":" + (Strings.isNullOrEmpty((String)this.sectionName) ? "<none>" : this.sectionName);
                    GuidebookMod.logger.error(String.format("Invalid section reference: \"%s\" in book \"%s\" caused by: %s", ref_string, bookDocument.getName(), e));
                    return false;
                }
            }
        }
        return true;
    }

    public SectionRef copy() {
        return new SectionRef(this.chapter, this.section);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SectionRef)) {
            return false;
        }
        SectionRef pr = (SectionRef)obj;
        return this.resolvedNames && pr.resolvedNames && pr.chapter == this.chapter && pr.section == this.section;
    }

    public int hashCode() {
        if (!this.resolvedNames) {
            return 0;
        }
        return this.chapter * 313 + this.section;
    }

    public static class InvalidPageRefException
    extends Exception {
        public InvalidPageRefException(String s) {
            super(s);
        }
    }
}

