/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.MultiBlockStorage;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EnergyCoreBuilder
implements IProcess {
    private final TileEnergyStorageCore core;
    private final EntityPlayer player;
    private boolean isDead = false;
    private Map<BlockPos, IBlockState> workList = new HashMap<BlockPos, IBlockState>();
    private LinkedList<BlockPos> workOrder = new LinkedList();
    private World world;

    public EnergyCoreBuilder(TileEnergyStorageCore core, EntityPlayer player) {
        this.core = core;
        this.player = player;
        this.world = core.func_145831_w();
        this.buildWorkList();
    }

    private void buildWorkList() {
        EnergyCoreStructure structure = this.core.coreStructure;
        MultiBlockStorage storage = structure.getStorageForTier(this.core.tier.value);
        BlockPos start = this.core.func_174877_v().func_177971_a((Vec3i)structure.getCoreOffset(this.core.tier.value));
        HashMap structureBlocks = new HashMap();
        storage.forEachBlock(start, (key1, value) -> {
            HashMap<String, Block> blockCache = new HashMap<String, Block>();
            structureBlocks.put(key1, blockCache.computeIfAbsent((String)value, s -> Block.func_149684_b((String)value)));
        });
        World world = this.core.func_145831_w();
        for (BlockPos key : structureBlocks.keySet()) {
            Block targetBlock = (Block)structureBlocks.get(key);
            if (targetBlock == null) continue;
            if (world.func_175623_d(key)) {
                this.workList.put(key, targetBlock.func_176223_P());
                continue;
            }
            IBlockState state = world.func_180495_p(key);
            if (state.func_177230_c() == targetBlock) continue;
            this.isDead = true;
            this.player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_found_invalid.txt", new Object[]{state.func_177230_c().func_149732_F(), key.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return;
        }
        this.workOrder.addAll(this.workList.keySet());
        this.workOrder.sort(Comparator.comparingInt(value -> (int)value.func_177951_i((Vec3i)this.core.func_174877_v())));
    }

    public void updateProcess() {
        if (this.workOrder.isEmpty() || this.player.field_70128_L) {
            this.isDead = true;
            return;
        }
        BlockPos pos = this.workOrder.poll();
        IBlockState state = this.workList.get(pos);
        if (!this.world.func_175623_d(pos)) {
            if (this.world.func_180495_p(pos).func_177230_c() == state.func_177230_c()) {
                return;
            }
            this.player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_error_expected_air.txt", new Object[]{pos.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            this.isDead = true;
            return;
        }
        ItemStack required = new ItemStack(state.func_177230_c());
        if (this.player.field_71075_bZ.field_75098_d || this.extractItem(required)) {
            this.world.func_175656_a(pos, state);
            SoundType soundtype = state.func_177230_c().getSoundType(state, this.world, pos, (Entity)this.player);
            this.world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        } else {
            this.player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_missing_required.txt", new Object[]{state.func_177230_c().func_149732_F()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            this.isDead = true;
        }
    }

    private boolean extractItem(ItemStack toExtract) {
        IItemHandler handler = (IItemHandler)this.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack inSlot = handler.getStackInSlot(i);
            if (inSlot.func_190926_b() || inSlot.func_77973_b() != toExtract.func_77973_b() || (extracted = handler.extractItem(i, 1, false)).func_190926_b() || extracted.func_77973_b() != toExtract.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

