/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.DragonChunkLoader;
import com.brandon3055.draconicevolution.entity.EntityDragonOld;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.entity.EntityGuardianProjectile;
import com.brandon3055.draconicevolution.lib.DEDamageSources;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityChaosGuardian
extends EntityDragonOld {
    private static final List<Block> DESTRUCTION_BLACKLIST = ImmutableList.of((Object)Blocks.field_150377_bs, (Object)Blocks.field_150343_Z);
    private static final DataParameter<Optional<BlockPos>> CRYSTAL_POSITION = EntityDataManager.func_187226_a(EntityChaosGuardian.class, (DataSerializer)DataSerializers.field_187201_k);
    private Entity target;
    public int homeX = 0;
    public int homeY = -1;
    public int homeZ = 0;
    public boolean homeSet = false;
    public double targetX;
    public double targetY;
    public double targetZ;
    public boolean forceNewTarget;
    private int nextAttackTimer = 100;
    private int attackInProgress = -1;
    private int attackTimer = 0;
    private EnumBehaviour previousBehaviour = EnumBehaviour.ROAMING;
    private int ignitionChargeTimer = 0;
    public List<EntityGuardianCrystal> crystals = null;
    public int activeCrystals = 0;
    public EntityGuardianCrystal healingChaosCrystal;
    private static final int ATTACK_FIREBALL_CHARGE = 0;
    private static final int ATTACK_FIREBALL_CHASER = 1;
    private static final int ATTACK_ENERGY_CHASER = 2;
    private static final int ATTACK_CHAOS_CHASER = 3;
    private static final int ATTACK_TELEPORT = 4;
    public float circlePosition = 0.0f;
    public float circleDirection = 1.0f;
    public EnumBehaviour behaviour = EnumBehaviour.ROAMING;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true).func_186743_c(true);
    private static final List<WeightedAttack> weightedAttacks = Lists.newArrayList((Object[])new WeightedAttack[]{new WeightedAttack(16, 0), new WeightedAttack(14, 1), new WeightedAttack(12, 2), new WeightedAttack(10, 3)});
    private static final List<WeightedAttack> weightedLowHealthAttaxks = Lists.newArrayList((Object[])new WeightedAttack[]{new WeightedAttack(5, 1), new WeightedAttack(5, 4), new WeightedAttack(10, 2), new WeightedAttack(15, 3)});
    private static final List<WeightedBehaviour> weightedBehaviours = Lists.newArrayList((Object[])new WeightedBehaviour[]{new WeightedBehaviour(1, EnumBehaviour.LOW_HEALTH_STRATEGY), new WeightedBehaviour(10, EnumBehaviour.GUARDING), new WeightedBehaviour(4, EnumBehaviour.CHARGING), new WeightedBehaviour(12, EnumBehaviour.FIREBOMB), new WeightedBehaviour(20, EnumBehaviour.CIRCLE_PLAYER)});

    public EntityChaosGuardian(World par1World) {
        super(par1World);
        this.func_110163_bv();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CRYSTAL_POSITION, (Object)Optional.absent());
    }

    public boolean func_104002_bU() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)DEConfig.chaosGuardianHealth);
    }

    @Override
    public void func_70636_d() {
        float f12;
        double d2;
        double d1;
        double d10;
        float f2;
        float f1;
        float f;
        if (!this.homeSet) {
            this.homeX = (int)this.field_70165_t;
            this.homeY = (int)this.field_70163_u;
            this.homeZ = (int)this.field_70161_v;
            this.targetX = this.homeX;
            this.targetZ = this.homeZ;
            this.homeSet = true;
        }
        if (this.crystals == null) {
            this.updateCrystals();
        }
        float moveSpeedMultiplier = this.behaviour.dragonSpeed;
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.deathTicks <= 0) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, SoundCategory.HOSTILE, 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (!this.field_70170_p.field_72995_K) {
            this.updateTarget();
            if (Utils.getClosestPlayer((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)500.0, (boolean)true, (boolean)true) == null && this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 100.0) {
                DragonChunkLoader.stopLoading(this);
                return;
            }
            if (this.func_110143_aJ() > 0.0f) {
                DragonChunkLoader.updateLoaded(this);
            }
            if (this.deathTicks > 0) {
                DragonChunkLoader.stopLoading(this);
            }
            this.customAIUpdate();
            if (this.behaviour == EnumBehaviour.FIREBOMB && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
                moveSpeedMultiplier = 0.0f;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.behaviour = EnumBehaviour.DEAD;
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        this.updateDragonEnderCrystal();
        f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
        f *= moveSpeedMultiplier == 0.0f ? 1.0f : moveSpeedMultiplier;
        this.animTime = this.slowed ? (this.animTime += f * 0.5f) : (this.animTime += (f *= (float)Math.pow(2.0, this.field_70181_x)));
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        if (this.ringBufferIndex < 0) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i][0] = this.field_70177_z;
                this.ringBuffer[i][1] = this.field_70163_u;
            }
        }
        if (++this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
        this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70716_bi > 0) {
                d10 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(d10, d0, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            if (this.target != null && (this.target.field_70128_L || !this.target.func_70089_S() || this.target.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 300.0)) {
                this.target = null;
            }
            d10 = this.targetX - this.field_70165_t;
            double d0 = this.targetY - this.field_70163_u;
            d1 = this.targetZ - this.field_70161_v;
            d2 = d10 * d10 + d0 * d0 + d1 * d1;
            if (this.target != null) {
                if (this.behaviour == EnumBehaviour.CIRCLE_PLAYER) {
                    this.targetX = this.target.field_70165_t + (double)((int)(Math.cos(this.circlePosition) * 60.0));
                    this.targetZ = this.target.field_70161_v + (double)((int)(Math.sin(this.circlePosition) * 60.0));
                    moveSpeedMultiplier = 1.0f + Math.min((float)Utils.getDistanceAtoB((double)this.targetX, (double)this.targetZ, (double)this.field_70165_t, (double)this.field_70161_v) / 50.0f * 3.0f, 3.0f);
                } else {
                    this.targetX = this.target.field_70165_t;
                    this.targetZ = this.target.field_70161_v;
                }
                double d3 = this.targetX - this.field_70165_t;
                double d5 = this.targetZ - this.field_70161_v;
                double d7 = Math.sqrt(d3 * d3 + d5 * d5);
                double d8 = (double)0.4f + d7 / 80.0 - 1.0;
                if (d8 > 10.0) {
                    d8 = 10.0;
                }
                this.targetY = this.target.func_174813_aQ().field_72338_b + d8 + (double)(this.behaviour == EnumBehaviour.CIRCLE_PLAYER ? 25 : 0);
            } else if (this.behaviour != EnumBehaviour.FIREBOMB) {
                this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
            }
            if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                this.setNewTarget();
            }
            if ((d0 /= (double)MathHelper.func_76133_a((double)(d10 * d10 + d1 * d1))) < (double)(-(f12 = 0.6f))) {
                d0 = -f12;
            }
            if (d0 > (double)f12) {
                d0 = f12;
            }
            this.field_70181_x += d0 * (double)0.1f;
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            double d4 = 180.0 - Math.atan2(d10, d1) * 180.0 / Math.PI;
            double d6 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z));
            if (d6 > 50.0) {
                d6 = 50.0;
            }
            if (d6 < -50.0) {
                d6 = -50.0;
            }
            Vec3d vec3 = new Vec3d(this.targetX - this.field_70165_t, this.targetY - this.field_70163_u, this.targetZ - this.field_70161_v).func_72432_b();
            Vec3d vec32 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
            float f5 = (float)(vec32.func_72430_b(vec3) + 0.5) / 1.5f;
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            this.field_70704_bt *= 0.8f;
            float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
            double d9 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
            if (d9 > 40.0) {
                d9 = 40.0;
            }
            this.field_70704_bt = (float)((double)this.field_70704_bt + d6 * ((double)0.7f / d9 / (double)f6));
            this.field_70177_z += this.field_70704_bt * 0.1f;
            float f7 = (float)(2.0 / (d9 + 1.0));
            float f8 = 0.06f;
            this.func_191958_b(0.0f, 0.0f, -1.0f, 0.06f * (f7 * f8 + (1.0f - f8)));
            if (this.slowed) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)0.8f * (double)moveSpeedMultiplier, this.field_70181_x * (double)0.8f * (double)moveSpeedMultiplier, this.field_70179_y * (double)0.8f * (double)moveSpeedMultiplier);
            } else {
                this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)moveSpeedMultiplier, this.field_70181_x * (double)moveSpeedMultiplier, this.field_70179_y * (double)moveSpeedMultiplier);
            }
            Vec3d vec31 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            float f9 = (float)(vec31.func_72430_b(vec32) + 1.0) / 2.0f;
            f9 = 0.8f + 0.15f * f9;
            this.field_70159_w *= (double)f9;
            this.field_70179_y *= (double)f9;
            this.field_70181_x *= (double)0.91f;
        }
        this.field_70761_aq = this.field_70177_z;
        this.dragonPartHead.field_70131_O = 3.0f;
        this.dragonPartHead.field_70130_N = 3.0f;
        this.dragonPartTail1.field_70131_O = 2.0f;
        this.dragonPartTail1.field_70130_N = 2.0f;
        this.dragonPartTail2.field_70131_O = 2.0f;
        this.dragonPartTail2.field_70130_N = 2.0f;
        this.dragonPartTail3.field_70131_O = 2.0f;
        this.dragonPartTail3.field_70130_N = 2.0f;
        this.dragonPartBody.field_70131_O = 3.0f;
        this.dragonPartBody.field_70130_N = 5.0f;
        this.dragonPartWing1.field_70131_O = 2.0f;
        this.dragonPartWing1.field_70130_N = 4.0f;
        this.dragonPartWing2.field_70131_O = 3.0f;
        this.dragonPartWing2.field_70130_N = 4.0f;
        f1 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
        f2 = MathHelper.func_76134_b((float)f1);
        float f10 = -MathHelper.func_76126_a((float)f1);
        float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f11 = MathHelper.func_76126_a((float)f3);
        float f4 = MathHelper.func_76134_b((float)f3);
        this.dragonPartBody.func_70071_h_();
        this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f11 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f4 * 0.5f), 0.0f, 0.0f);
        this.dragonPartWing1.func_70071_h_();
        this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f11 * 4.5f), 0.0f, 0.0f);
        this.dragonPartWing2.func_70071_h_();
        this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f11 * 4.5f), 0.0f, 0.0f);
        if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0)));
        }
        double[] adouble1 = this.getMovementOffsets(5, 1.0f);
        double[] adouble = this.getMovementOffsets(0, 1.0f);
        f12 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
        float f13 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
        this.dragonPartHead.func_70071_h_();
        this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f12 * 5.5f * f2), this.field_70163_u + (adouble[1] - adouble1[1]) * 1.0 + (double)(f10 * 5.5f), this.field_70161_v - (double)(f13 * 5.5f * f2), 0.0f, 0.0f);
        for (int j = 0; j < 3; ++j) {
            MultiPartEntityPart entitydragonpart = null;
            if (j == 0) {
                entitydragonpart = this.dragonPartTail1;
            }
            if (j == 1) {
                entitydragonpart = this.dragonPartTail2;
            }
            if (j == 2) {
                entitydragonpart = this.dragonPartTail3;
            }
            double[] adouble2 = this.getMovementOffsets(12 + j * 2, 1.0f);
            float f14 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble1[0]) * (float)Math.PI / 180.0f * 1.0f;
            float f15 = MathHelper.func_76126_a((float)f14);
            float f16 = MathHelper.func_76134_b((float)f14);
            float f17 = 1.5f;
            float f18 = (float)(j + 1) * 2.0f;
            entitydragonpart.func_70071_h_();
            entitydragonpart.func_70012_b(this.field_70165_t - (double)((f11 * f17 + f15 * f18) * f2), this.field_70163_u + (adouble2[1] - adouble1[1]) * 1.0 - (double)((f18 + f17) * f10) + 1.5, this.field_70161_v + (double)((f4 * f17 + f16 * f18) * f2), 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ()) | this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
        }
    }

    public void onCrystalTargeted(EntityPlayer player, boolean destroyed) {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.target = player;
        ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)player);
        if (destroyed || this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY) {
            this.attackInProgress = 3;
            this.behaviour = EnumBehaviour.CHARGING;
            this.nextAttackTimer = 20;
            this.attackTimer = 100;
            this.updateCrystals();
        } else {
            this.attackInProgress = 0;
            this.previousBehaviour = this.behaviour;
            this.behaviour = EnumBehaviour.CHARGING;
            this.nextAttackTimer = 20;
            this.attackTimer = 1000;
        }
        if (this.deathTicks <= 0) {
            this.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 20.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
        }
    }

    public void updateCrystals() {
        if (this.crystals == null) {
            this.crystals = new ArrayList<EntityGuardianCrystal>();
        }
        List list = this.field_70170_p.func_72872_a(EntityGuardianCrystal.class, new AxisAlignedBB((double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)this.homeX, (double)this.homeY, (double)this.homeZ).func_72314_b(200.0, 200.0, 200.0));
        this.activeCrystals = 0;
        for (EntityGuardianCrystal crystal : list) {
            if (!this.crystals.contains((Object)crystal)) {
                this.crystals.add(crystal);
            }
            if (!crystal.isAlive()) continue;
            ++this.activeCrystals;
        }
    }

    private void customAIUpdate() {
        if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP() * 0.2f) {
            this.behaviour = EnumBehaviour.LOW_HEALTH_STRATEGY;
        }
        if (this.field_70173_aa % 200 == 0) {
            this.crystals = null;
            this.activeCrystals = 0;
            this.setCrystalPos(null);
            this.healingChaosCrystal = null;
            this.updateCrystals();
        }
        switch (this.behaviour) {
            case ROAMING: {
                if (Utils.getClosestPlayer((World)this.field_70170_p, (double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)200.0, (boolean)true) == null) break;
                this.selectNewBehaviour();
                break;
            }
            case GO_HOME: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) < 70.0)) break;
                this.selectNewBehaviour();
                break;
            }
            case GUARDING: {
                break;
            }
            case CHARGING: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case CIRCLE_PLAYER: {
                this.circlePosition += 0.02f * this.circleDirection;
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0) && !(this.field_70163_u > 250.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (Utils.getClosestPlayer((World)this.field_70170_p, (double)this.targetX, (double)this.targetY, (double)this.targetZ, (double)60.0, (boolean)true) == null || this.attackInProgress == 4) break;
                boolean flag = false;
                for (int escape = 0; !flag && escape < 50; ++escape) {
                    this.targetX = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                    this.targetY = (double)(this.homeY + 30) + this.field_70146_Z.nextDouble() * 20.0;
                    this.targetZ = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                    if (Utils.getClosestPlayer((World)this.field_70170_p, (double)this.targetX, (double)this.targetY, (double)this.targetZ, (double)60.0, (boolean)true) != null) continue;
                    flag = true;
                }
                this.target = null;
                break;
            }
            case DEAD: {
                this.target = null;
                this.targetX = this.homeX;
                this.targetY = this.homeY;
                this.targetZ = this.homeZ;
            }
        }
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.field_70173_aa % 1000 == 0 && this.field_70146_Z.nextBoolean()) {
            this.selectNewBehaviour();
        }
        if (this.ignitionChargeTimer > 1 || this.ignitionChargeTimer == 1 && this.field_70173_aa % 20 == 0 && !DEConfig.disableGuardianCrystalRespawn) {
            --this.ignitionChargeTimer;
        }
        if (this.ignitionChargeTimer <= 0 && !this.field_70170_p.field_72995_K) {
            if ((this.field_70173_aa - 19) % 20 == 0) {
                this.ignitionChargeTimer = (this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 1000 : 2000) + this.field_70146_Z.nextInt(600);
            }
            if (this.activeCrystals < this.crystals.size() && this.field_70173_aa % 10 == 0) {
                EntityGuardianCrystal closest = null;
                for (EntityGuardianCrystal crystal : this.crystals) {
                    if (crystal.isAlive() || closest != null && !(this.func_70032_d((Entity)crystal) < this.func_70032_d((Entity)closest))) continue;
                    closest = crystal;
                }
                if (closest != null) {
                    EntityGuardianProjectile charge = new EntityGuardianProjectile(this.field_70170_p, 7, closest, 0.0f, (Entity)this);
                    charge.func_70107_b(this.dragonPartHead.field_70165_t + Math.cos((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0, this.dragonPartHead.field_70163_u + 1.5, this.dragonPartHead.field_70161_v + Math.sin((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0);
                    this.field_70170_p.func_72838_d((Entity)charge);
                }
            }
        }
        this.updateAttack();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private void updateAttack() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.behaviour == EnumBehaviour.FIREBOMB && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
            if (this.target == null || this.field_70173_aa % 100 == 0) {
                this.setNewTarget();
            }
            if (this.target != null) {
                double distance = Utils.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                if (Utils.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) < 5.0) {
                    distance *= -1.0;
                }
                float anglePitch = (float)Math.toDegrees(Math.atan2(this.target.field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                float angleYaw = (float)Math.toDegrees(Math.atan2(this.target.field_70165_t - this.dragonPartHead.field_70165_t, this.target.field_70161_v - this.field_70161_v)) * -1.0f;
                this.field_70125_A = anglePitch;
                if (Utils.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) > 8.0) {
                    this.field_70177_z = angleYaw + 180.0f;
                }
                if (this.field_70173_aa % 2 == 0) {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1, this.target instanceof EntityLivingBase ? (EntityLivingBase)this.target : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t + Math.cos((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0, this.dragonPartHead.field_70163_u + 1.5, this.dragonPartHead.field_70161_v + Math.sin((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                }
            }
        } else if (this.nextAttackTimer > 0) {
            --this.nextAttackTimer;
        } else if (this.nextAttackTimer == 0) {
            List targets;
            Entity attackTarget = this.target;
            List list = targets = attackTarget == null ? this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)this.homeX, (double)this.homeY, (double)this.homeZ).func_72314_b(100.0, 100.0, 100.0)) : null;
            if (targets != null && targets.size() > 0) {
                targets.removeIf(player -> player.field_71075_bZ.field_75098_d);
            }
            if (attackTarget == null && targets.size() > 0) {
                attackTarget = (Entity)targets.get(this.field_70146_Z.nextInt(targets.size()));
            }
            if (attackTarget == null) {
                return;
            }
            if (this.attackInProgress == -1) {
                this.selectNewAttack();
                switch (this.attackInProgress) {
                    case 0: {
                        this.attackTimer = 90 + this.field_70146_Z.nextInt(80);
                        this.previousBehaviour = this.behaviour;
                        this.behaviour = EnumBehaviour.CHARGING;
                        break;
                    }
                    case 1: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 2: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 3: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 4: {
                        this.attackTimer = 90 + this.field_70146_Z.nextInt(80);
                    }
                }
            }
            switch (this.attackInProgress) {
                case 0: {
                    if (this.target == null && this.behaviour == EnumBehaviour.CHARGING) {
                        this.target = attackTarget;
                        if (this.target instanceof EntityLivingBase) {
                            ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)this.target));
                        }
                    }
                    if (Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)attackTarget.field_70165_t, (double)attackTarget.field_70163_u, (double)attackTarget.field_70161_v) > 10.0) {
                        if (this.attackTimer % 2 == 0) {
                            EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utils.getDistanceAtoB((double)attackTarget.field_70165_t, (double)attackTarget.field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                        this.field_70125_A = (float)Math.toDegrees(Math.atan2(attackTarget.field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                    break;
                }
                case 1: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 3, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 2.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 2: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 4, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 3: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 5, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 4: {
                    if (this.target == null) {
                        this.target = Utils.getClosestPlayer((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (boolean)false);
                        if (this.target != null) {
                            ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)this.target));
                        }
                    }
                    if (this.target == null) {
                        this.attackInProgress = -1;
                        return;
                    }
                    if (Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)attackTarget.field_70165_t, (double)attackTarget.field_70163_u, (double)attackTarget.field_70161_v) > 15.0) {
                        if (this.attackTimer % 2 == 0) {
                            EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 2, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utils.getDistanceAtoB((double)attackTarget.field_70165_t, (double)attackTarget.field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                        this.field_70125_A = (float)Math.toDegrees(Math.atan2(attackTarget.field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                }
            }
            --this.attackTimer;
            if (this.attackTimer <= -1) {
                if (this.attackInProgress == 0) {
                    this.behaviour = this.previousBehaviour;
                }
                this.attackInProgress = -1;
                this.nextAttackTimer = -1;
            }
        } else {
            this.nextAttackTimer = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 10 + this.field_70146_Z.nextInt(50) : 60 + this.field_70146_Z.nextInt(200);
        }
    }

    private void selectNewAttack() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.attackInProgress = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? ((WeightedAttack)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedLowHealthAttaxks)).attack : (this.behaviour != EnumBehaviour.FIREBOMB ? ((WeightedAttack)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedAttacks)).attack : 2);
    }

    private void selectNewBehaviour() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        EnumBehaviour newBehaviour = this.behaviour;
        while (newBehaviour == this.behaviour) {
            newBehaviour = ((WeightedBehaviour)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedBehaviours)).randomBehaviour;
        }
        this.previousBehaviour = this.behaviour = newBehaviour;
    }

    private void updateTarget() {
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                break;
            }
            case CHARGING: {
                break;
            }
            case FIREBOMB: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) > 3.0)) break;
                this.targetX = this.homeX;
                this.targetY = this.homeY + 30;
                this.targetZ = this.homeZ;
                break;
            }
            case CIRCLE_PLAYER: {
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                break;
            }
            case DEAD: {
                this.targetX = this.homeX;
                this.targetY = this.homeY;
                this.targetZ = this.homeZ;
                this.target = null;
            }
        }
    }

    private void setNewTarget() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.forceNewTarget = false;
        switch (this.behaviour) {
            case ROAMING: {
                double d2;
                double d1;
                double d0;
                boolean flag = false;
                do {
                    this.targetX = this.homeX;
                    this.targetY = (double)(this.homeY + 30) + this.field_70146_Z.nextDouble() * 30.0;
                    this.targetZ = this.homeZ;
                    this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                    this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
                this.target = null;
                break;
            }
            case GO_HOME: 
            case GUARDING: {
                this.targetX = this.homeX;
                this.targetY = (double)(this.homeY + 25) + this.field_70146_Z.nextDouble() * 30.0;
                this.targetZ = this.homeZ;
                this.target = null;
                break;
            }
            case CHARGING: 
            case CIRCLE_PLAYER: {
                this.target = Utils.getClosestPlayer((World)this.field_70170_p, (double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)200.0, (boolean)false);
                if (this.target == null) break;
                ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)this.target));
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                break;
            }
            case FIREBOMB: {
                List targets = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(150.0, 150.0, 150.0), EntitySelectors.field_188444_d);
                this.target = null;
                while (targets.size() > 0 && this.target == null) {
                    EntityPlayer potentialTarget = (EntityPlayer)targets.get(this.field_70146_Z.nextInt(targets.size()));
                    if (this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(potentialTarget.field_70165_t, potentialTarget.field_70163_u, potentialTarget.field_70161_v)) == null) {
                        this.target = potentialTarget;
                        ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)this.target));
                        continue;
                    }
                    targets.remove(potentialTarget);
                }
                break;
            }
        }
    }

    @Override
    public boolean func_70965_a(MultiPartEntityPart part, DamageSource damageSource, float dmg) {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return false;
        }
        if (part != this.dragonPartHead) {
            dmg = dmg / 4.0f + 1.0f;
        }
        if (dmg > 50.0f) {
            dmg = (float)((double)dmg - (double)(dmg - 50.0f) * 0.7);
        }
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                if (this.field_70146_Z.nextInt(5) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CHARGING: {
                if (this.field_70146_Z.nextInt(6) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CIRCLE_PLAYER: {
                if (this.field_70146_Z.nextInt(6) == 0) {
                    this.selectNewBehaviour();
                    break;
                }
                if (this.field_70146_Z.nextInt(4) != 0) break;
                this.circleDirection *= -1.0f;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (this.field_70146_Z.nextInt(6) == 0 && this.func_110143_aJ() >= this.func_110138_aP() * 0.2f) {
                    this.selectNewBehaviour();
                }
                if (!(damageSource.func_76346_g() instanceof EntityPlayer) || this.attackInProgress == 4) break;
                boolean flag = false;
                for (int escape = 0; !flag && escape < 50; ++escape) {
                    this.targetX = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                    this.targetY = (double)(this.homeY + 20) + (this.field_70146_Z.nextDouble() - 0.5) * 50.0;
                    this.targetZ = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                    if (!(this.func_70032_d(damageSource.func_76364_f()) >= 70.0f)) continue;
                    flag = true;
                }
                this.target = null;
                break;
            }
            case FIREBOMB: {
                if (this.target == null && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0 || this.field_70146_Z.nextInt(5) == 0) {
                    this.selectNewBehaviour();
                }
                if (!(damageSource.func_76346_g() instanceof EntityPlayer) || damageSource.func_76346_g() == this.target || this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(damageSource.func_76346_g().field_70165_t, damageSource.func_76346_g().field_70163_u, damageSource.func_76346_g().field_70161_v)) != null) break;
                this.target = damageSource.func_76346_g();
                if (!(this.target instanceof EntityLivingBase)) break;
                ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)this.target));
                break;
            }
        }
        if ((damageSource.func_76346_g() instanceof EntityPlayer || damageSource.func_94541_c()) && this.healingChaosCrystal == null) {
            super.func_70097_a(damageSource, dmg);
        } else if (damageSource.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.func_76346_g()).func_145747_a(new TextComponentTranslation("msg.de.guardianAttackBlocked.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
        }
        return true;
    }

    @Override
    protected void func_70609_aI() {
        if (this.deathTicks == 0) {
            TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY, this.homeZ));
            if (tile instanceof TileChaosCrystal) {
                ((TileChaosCrystal)tile).setDefeated();
            } else {
                boolean breac = false;
                for (int x = this.homeX - 100; x < this.homeX + 100; ++x) {
                    for (int y = this.homeY - 100; y < this.homeY + 100; ++y) {
                        if (y < 0 || y > 255) continue;
                        for (int z = this.homeZ - 100; z < this.homeZ + 100; ++z) {
                            tile = this.field_70170_p.func_175625_s(new BlockPos(x, y, z));
                            if (tile instanceof TileChaosCrystal) {
                                ((TileChaosCrystal)tile).setDefeated();
                                breac = true;
                            }
                            if (breac) break;
                        }
                        if (breac) break;
                    }
                    if (breac) break;
                }
            }
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.deathTicks == 1) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187522_aL, SoundCategory.HOSTILE, 50.0f, 1.0f, false);
        }
        if (this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 20.0 && this.deathTicks % 2 == 0) {
            EntityLightningBolt bolt = new EntityLightningBolt(this.field_70170_p, (double)this.homeX, (double)(this.homeY + 1), (double)this.homeZ, true);
            bolt.field_70158_ak = true;
            this.field_70170_p.func_72942_c((Entity)bolt);
        }
        if (this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 5.0 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 200000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.updateCrystals();
            for (EntityGuardianCrystal crystal : this.crystals) {
                crystal.setDeathTimer();
            }
            this.func_70106_y();
        }
    }

    private void collideWithEntities(List par1List) {
    }

    private void attackEntitiesInList(List par1List) {
        if (this.behaviour == EnumBehaviour.CHARGING) {
            boolean hasAttacked = false;
            for (int i = 0; i < par1List.size(); ++i) {
                Entity entity = (Entity)par1List.get(i);
                if (!(entity instanceof EntityPlayer)) continue;
                entity.func_70097_a((DamageSource)new DEDamageSources.DamageSourceChaos((Entity)this), 50.0f);
                hasAttacked = true;
            }
            if (hasAttacked && this.field_70146_Z.nextInt(2) == 0) {
                this.behaviour = EnumBehaviour.GUARDING;
            }
        }
    }

    private void updateDragonEnderCrystal() {
        if (this.field_70170_p.field_72995_K) {
            BlockPos pos = this.getCrystalPos();
            if (this.healingChaosCrystal == null && pos != null && this.field_70173_aa % 10 == 0) {
                List list = this.field_70170_p.func_72872_a(EntityGuardianCrystal.class, new AxisAlignedBB(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(3, 3, 3)));
                if (list.size() > 0) {
                    this.healingChaosCrystal = (EntityGuardianCrystal)((Object)list.get(0));
                }
            } else if (this.healingChaosCrystal != null && (pos == null || Utils.getDistanceSq((double)this.healingChaosCrystal.field_70165_t, (double)this.healingChaosCrystal.field_70163_u, (double)this.healingChaosCrystal.field_70161_v, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 10.0)) {
                this.healingChaosCrystal = null;
            }
            return;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.healingChaosCrystal = null;
            this.setCrystalPos(null);
            return;
        }
        if (this.healingChaosCrystal != null) {
            if (!this.healingChaosCrystal.isAlive()) {
                this.func_70965_a(this.dragonPartHead, DamageSource.func_94539_a((Explosion)null), 10.0f);
                this.healingChaosCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 2.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            EntityGuardianCrystal closest = null;
            for (EntityGuardianCrystal crystal : this.crystals) {
                if (!crystal.isAlive() || closest != null && !(this.func_70032_d((Entity)crystal) < this.func_70032_d((Entity)closest))) continue;
                closest = crystal;
            }
            this.healingChaosCrystal = closest;
            if (this.healingChaosCrystal != null) {
                this.setCrystalPos(new BlockPos((int)Math.floor(this.healingChaosCrystal.field_70165_t), (int)Math.floor(this.healingChaosCrystal.field_70163_u), (int)Math.floor(this.healingChaosCrystal.field_70161_v)));
            } else {
                this.setCrystalPos(null);
            }
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int l = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int x = i; x <= l; ++x) {
            for (int y = j; y <= i1; ++y) {
                for (int z = k; z <= j1; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (this.field_70170_p.func_175623_d(pos) || DESTRUCTION_BLACKLIST.contains(block)) continue;
                    if (block.canEntityDestroy(state, (IBlockAccess)this.field_70170_p, pos, (Entity)this) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(pos) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = par1AxisAlignedBB.field_72340_a + (par1AxisAlignedBB.field_72336_d - par1AxisAlignedBB.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = par1AxisAlignedBB.field_72338_b + (par1AxisAlignedBB.field_72337_e - par1AxisAlignedBB.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = par1AxisAlignedBB.field_72339_c + (par1AxisAlignedBB.field_72334_f - par1AxisAlignedBB.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    private void spawnEgg() {
    }

    private void createEnderPortal(int par1, int par2) {
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74768_a("HomeXCoord", this.homeX);
        compound.func_74768_a("HomeYCoord", this.homeY);
        compound.func_74768_a("HomeZCoord", this.homeZ);
        compound.func_74778_a("Behaviour", this.behaviour.name());
        compound.func_74757_a("HomeSet", this.homeSet);
        int chunkX = MathHelper.func_76128_c((double)(this.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(this.field_70161_v / 16.0));
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.homeX = compound.func_74762_e("HomeXCoord");
        this.homeY = compound.func_74762_e("HomeYCoord");
        this.homeZ = compound.func_74762_e("HomeZCoord");
        if (compound.func_74764_b("Behaviour")) {
            this.behaviour = EnumBehaviour.valueOf(compound.func_74779_i("Behaviour"));
        }
        this.homeSet = compound.func_74767_n("HomeSet");
        this.targetX = this.homeX;
        this.targetZ = this.homeZ;
        int chunkX = MathHelper.func_76128_c((double)(this.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(this.field_70161_v / 16.0));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_70623_bb() {
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float dmg) {
        return super.func_70097_a(damageSource, dmg);
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        return this;
    }

    public void setCrystalPos(@Nullable BlockPos pos) {
        this.func_184212_Q().func_187227_b(CRYSTAL_POSITION, (Object)Optional.fromNullable((Object)pos));
    }

    @Nullable
    public BlockPos getCrystalPos() {
        return (BlockPos)((Optional)this.func_184212_Q().func_187225_a(CRYSTAL_POSITION)).orNull();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.37;
    }

    private static class WeightedBehaviour
    extends WeightedRandom.Item {
        public EnumBehaviour randomBehaviour;

        public WeightedBehaviour(int weight, EnumBehaviour randomBehaviour) {
            super(weight);
            this.randomBehaviour = randomBehaviour;
        }
    }

    private static class WeightedAttack
    extends WeightedRandom.Item {
        public int attack;

        public WeightedAttack(int weight, int attack) {
            super(weight);
            this.attack = attack;
        }
    }

    private static enum EnumBehaviour {
        ROAMING(1.0f),
        GO_HOME(1.3f),
        GUARDING(0.8f),
        CHARGING(2.0f),
        FIREBOMB(1.5f),
        CIRCLE_PLAYER(1.2f),
        LOW_HEALTH_STRATEGY(2.0f),
        DEAD(0.5f);

        public float dragonSpeed;

        private EnumBehaviour(float dragonSpeed) {
            this.dragonSpeed = dragonSpeed;
        }
    }
}

