/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree;

import codechicken.lib.colour.ColourARGB;
import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiStackIcon;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.guielements.PopupEditContent;
import com.brandon3055.draconicevolution.client.gui.modwiki.guielements.PopupEditMod;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.SwingHelper;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.UIAddBranch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TreeBranchContent
extends TreeBranchRoot {
    private MGuiLabel label;
    private MGuiElementBase icon;
    private MGuiElementBase iconBackground;

    public TreeBranchContent(GuiModWiki guiWiki, TreeBranchRoot parent, Element branchData, String contentName) {
        super(guiWiki, parent, contentName);
        this.branchData = branchData;
        this.xSize = guiWiki.wikiList.getListEntryWidth();
    }

    @Override
    public void initBranches() {
        this.removeChild((MGuiElementBase)this.label);
        this.removeChild(this.icon);
        this.label = new MGuiLabel((IModularGui)this.guiWiki, this.xPos, this.yPos, this.xSize, this.ySize, this.branchName){

            public int getTextColour() {
                return WikiConfig.NAV_TEXT;
            }

            public boolean getDropShadow() {
                ColourARGB colour = new ColourARGB(WikiConfig.NAV_TEXT);
                long l = ((colour.r & 0xFF) + (colour.g & 0xFF) + (colour.b & 0xFF)) / 3;
                return l > 80L;
            }
        }.setAlignment(EnumAlignment.LEFT).setWrap(true);
        this.addChild((MGuiElementBase)this.label);
        StackReference stackReference = this.getDisplayStack();
        if (stackReference != null) {
            MGuiStackIcon stackIcon = new MGuiStackIcon(this.modularGui, this.xPos, this.yPos, 18, 18, stackReference);
            MGuiSlotRender back = new MGuiSlotRender(this.modularGui, this.xPos, this.yPos, 18, 18);
            this.icon = stackIcon;
            this.addChild(this.icon);
            this.iconBackground = back;
            this.addChild(this.iconBackground);
            int line = this.modularGui.getMinecraft().field_71466_p.func_78271_c(this.branchName, this.label.xSize - 28).size();
            this.label.ySize = this.ySize = Math.max(22, line * this.modularGui.getMinecraft().field_71466_p.field_78288_b + 7);
            stackIcon.yOffset = (this.ySize - 18) / 2;
            stackIcon.xOffset = 3;
            back.yOffset = (this.ySize - 18) / 2;
            back.xOffset = 3;
        } else {
            this.icon = null;
        }
        this.initElement();
        this.positionElements(this.xPos, this.yPos);
        super.initBranches();
    }

    @Override
    public void positionElements(int newXPos, int newYPos) {
        if (this.icon != null) {
            this.label.xPos = this.icon.xPos + this.icon.xSize;
            this.label.xSize = this.xSize - this.icon.xSize;
            this.icon.yPos = this.yPos;
            if (this.iconBackground != null) {
                this.iconBackground.yPos = this.yPos;
            }
        }
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int back;
        boolean selected = this.isMouseOver(mouseX, mouseY) || this.guiWiki.wikiDataTree.getActiveBranch() == this;
        int navWindowColour = WikiConfig.NAV_WINDOW;
        if (this.isModBranch) {
            back = TreeBranchContent.mixColours((int)navWindowColour, (int)(selected ? 0x404040 : 0x202020));
            int pos = TreeBranchContent.mixColours((int)navWindowColour, (int)0x505050);
            int neg = TreeBranchContent.mixColours((int)navWindowColour, (int)0x202020, (boolean)true);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, back);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, this.xSize - 2, 0.5, pos);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, 0.5, this.ySize - 2, pos);
            this.drawColouredRect(this.xPos + 1, this.yPos + this.ySize - 1, this.xSize - 2, 0.5, neg);
            this.drawColouredRect(this.xPos + this.xSize - 1, this.yPos + 1, 0.5, this.ySize - 2, neg);
        } else {
            back = TreeBranchContent.mixColours((int)navWindowColour, (int)(selected ? 0x404040 : 0x202020));
            int pos = TreeBranchContent.mixColours((int)navWindowColour, (int)0x505050);
            int neg = TreeBranchContent.mixColours((int)navWindowColour, (int)0x202020, (boolean)true);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, back);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, this.xSize - 2, 0.5, pos);
            this.drawColouredRect(this.xPos + 1, this.yPos + 1, 0.5, this.ySize - 2, pos);
            this.drawColouredRect(this.xPos + 1, this.yPos + this.ySize - 1, this.xSize - 2, 0.5, neg);
            this.drawColouredRect(this.xPos + this.xSize - 1, this.yPos + 1, 0.5, this.ySize - 2, neg);
        }
        if (selected) {
            this.drawBorderedRect(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, 1.0, 0, -16777216);
        }
        if (WikiConfig.editMode && !this.isModBranch && WikiConfig.drawEditInfo) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.xPos, (float)this.yPos, (float)100.0f);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)1.0);
            String s = "W:\u00a7f" + this.sortingWeight;
            this.drawString(minecraft.field_71466_p, s, 0.0f, 0.0f, 0xFF0000, false);
            this.drawColouredRect(0.0, 0.0, minecraft.field_71466_p.func_78256_a(s), 8.0, -1442840576);
            GlStateManager.func_179121_F();
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (WikiConfig.editMode && this.isMouseOver(mouseX, mouseY)) {
            this.drawHoveringText(Collections.singletonList(TextFormatting.RED + "[Right click to edit]"), mouseX, mouseY, minecraft.field_71466_p, this.modularGui.screenWidth(), this.modularGui.screenHeight());
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (WikiConfig.editMode && this.isMouseOver(mouseX, mouseY) && mouseButton == 1) {
            if (this.isModBranch) {
                PopupEditMod editMod = new PopupEditMod(this.modularGui, this.list.xPos + 12, this.list.yPos + 24, this.list.xSize - 12 - this.list.rightPadding, this.list.ySize - 25, this.list, this);
                this.list.addChild((MGuiElementBase)editMod);
                this.list.disableList = true;
                editMod.initElement();
            } else {
                PopupEditContent editContent = new PopupEditContent(this.modularGui, this.list.xPos + 12, this.list.yPos + 24, this.list.xSize - 12 - this.list.rightPadding, this.list.ySize - 25, this.list, this);
                this.list.addChild((MGuiElementBase)editContent);
                this.list.disableList = true;
                editContent.initElement();
            }
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void loadBranchesXML() {
        if (!this.isModBranch) {
            this.loadNonModAttributes();
        }
        this.loadBranchContent();
        NodeList entryList = this.branchData.getElementsByTagName("entry");
        for (int entryIndex = 0; entryIndex < entryList.getLength(); ++entryIndex) {
            Element entry = (Element)entryList.item(entryIndex);
            if (entry.getParentNode() != this.branchData) continue;
            String name = entry.getAttribute("name");
            TreeBranchContent contentBranch = new TreeBranchContent(this.guiWiki, this, entry, name);
            this.addSubBranch(contentBranch);
            contentBranch.loadBranchesXML();
        }
        Collections.sort(this.subBranches, BRANCH_SORTER);
    }

    public void loadNonModAttributes() {
        if (this.branchData.hasAttribute("branchId")) {
            this.setBranchID(this.branchData.getAttribute("branchId"));
        }
        if (this.branchData.hasAttribute("category")) {
            String category = this.branchData.getAttribute("category");
            WikiDocManager.loadedCategories.add(category);
        }
    }

    public StackReference getDisplayStack() {
        if (!this.isModBranch && this.branchData.hasAttribute("iconType") && this.branchData.getAttribute("iconType").equals("stack") && this.branchData.hasAttribute("icon")) {
            String stackString = this.branchData.getAttribute("icon");
            StackReference stackRef = StackReference.fromString((String)stackString);
            if (stackRef == null) {
                stackRef = new StackReference("error");
            }
            return stackRef;
        }
        return null;
    }

    @Override
    public void createNewSubBranch() {
        UIAddBranch frame = new UIAddBranch(this, WikiDocManager.loadedCategories, this.branchID, new ArrayList<String>(this.guiWiki.wikiDataTree.idToBranchMap.keySet()));
        frame.pack();
        frame.setVisible(true);
        SwingHelper.centerOnMinecraftWindow(frame);
    }
}

