/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import codechicken.lib.data.MCDataInput;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXRing;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import fluxnetworks.common.tileentity.TileFluxPlug;
import fluxnetworks.common.tileentity.TileFluxPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrystalDirectIO
extends TileCrystalBase
implements IEnergyReceiver,
IEnergyProvider {
    public final ManagedEnum<EnumFacing> facing;
    public final ManagedBool outputMode;
    protected Map<Vec3B, EnumFacing> receiverSideMap;
    protected LinkedList<Vec3B> linkedReceivers;
    protected LinkedList<BlockPos> receiverCache;
    protected Map<BlockPos, EnumFacing> receiverFaceCache;
    protected List<LinkedDevice> fastList;
    protected List<LinkedDevice> slowList;
    public LinkedList<int[]> receiverTransferRates;
    public LinkedList<Byte> receiverFlowRates;
    public final ManagedBool inputMode;
    private static final Set<Class<? extends TileEntity>> EXCLUDED_TILE_ENTITIES = new HashSet<Class<? extends TileEntity>>();
    public Map<Integer, Integer> containerReceiverFlow;

    public TileCrystalDirectIO() {
        this.facing = (ManagedEnum)this.dataManager.register("facing", (IManagedData)new ManagedEnum((Enum)EnumFacing.DOWN)).syncViaTile().saveToTile().finish();
        this.outputMode = (ManagedBool)this.dataManager.register("outputMode", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().saveToItem().finish();
        this.receiverSideMap = new HashMap<Vec3B, EnumFacing>();
        this.linkedReceivers = new LinkedList();
        this.receiverCache = null;
        this.receiverFaceCache = null;
        this.fastList = new ArrayList<LinkedDevice>();
        this.slowList = new ArrayList<LinkedDevice>();
        this.receiverTransferRates = new LinkedList();
        this.receiverFlowRates = new LinkedList();
        this.inputMode = (ManagedBool)this.dataManager.register("inputMode", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().saveToItem().finish();
        this.containerReceiverFlow = new HashMap<Integer, Integer>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void scanForEnergyReceivers() {
        ChunkPos chunkPos = new ChunkPos(this.field_174879_c);
        for (TileEntity te : this.field_145850_b.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b).func_177434_r().values()) {
            EnumFacing side;
            BlockPos tePos = te.func_174877_v();
            if (!te.hasCapability(CapabilityEnergy.ENERGY, null) || (side = this.checkPowerSide(tePos)) == null) continue;
            this.addReceiver(tePos, side);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.scanForEnergyReceivers();
        }
    }

    public EnumFacing checkPowerSide(BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null) {
            for (EnumFacing side : EnumFacing.values()) {
                IEnergyStorage energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side);
                if (energyStorage == null || !energyStorage.canReceive()) continue;
                return side;
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        EnumFacing side;
        BlockPos placedPos;
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(placedPos = event.getPos());
        if (te != null && (te.hasCapability(CapabilityEnergy.ENERGY, null) || te instanceof IEnergyStorage) && this.field_174879_c.func_177958_n() >> 4 == placedPos.func_177958_n() >> 4 && this.field_174879_c.func_177952_p() >> 4 == placedPos.func_177952_p() >> 4 && (side = this.checkPowerSide(placedPos)) != null) {
            this.addReceiver(placedPos, side);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((EnumFacing)this.facing.value));
        if (this.outputMode.value && tile != null) {
            this.energyStorage.extractEnergy(EnergyHelper.insertEnergy((TileEntity)tile, (int)this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true), (EnumFacing)((EnumFacing)this.facing.value).func_176734_d(), (boolean)false), false);
        }
        this.updateEnergyFlow();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return from != null && !this.outputMode.value && from.equals((Object)this.facing.value) ? this.energyStorage.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return from != null && this.outputMode.value && from.equals((Object)this.facing.value) ? this.energyStorage.extractEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != null && from.equals((Object)this.facing.value);
    }

    @Override
    public EnergyCrystal.CrystalType getType() {
        return EnergyCrystal.CrystalType.CRYSTAL_IO;
    }

    @Override
    public void onTilePlaced(World world, BlockPos pos, EnumFacing placedAgainst, float hitX, float hitY, float hitZ, EntityPlayer placer, ItemStack stack) {
        super.onTilePlaced(world, pos, placedAgainst, hitX, hitY, hitZ, placer, stack);
        this.facing.value = placedAgainst.func_176734_d();
    }

    private void updateEnergyFlow() {
        if (this.receiverTransferRates.size() != this.linkedReceivers.size()) {
            this.rebuildReceiverTransferList();
        }
        this.getReceiversFaces();
        ArrayList<LinkedDevice> moveToSlow = new ArrayList<LinkedDevice>();
        for (LinkedDevice receiver : this.fastList) {
            if (!this.isValidReceiver(this.field_145850_b.func_175625_s(receiver.pos))) {
                this.removeReceiver(receiver.pos);
                return;
            }
            if (!this.updateDevice(receiver)) {
                this.removeReceiver(receiver.pos);
                return;
            }
            if (receiver.timeOut <= 40) continue;
            moveToSlow.add(receiver);
        }
        if (this.tick % 80 == 0) {
            ArrayList<LinkedDevice> moveToFast = new ArrayList<LinkedDevice>();
            for (LinkedDevice receiver : this.slowList) {
                if (!this.isValidReceiver(this.field_145850_b.func_175625_s(receiver.pos))) {
                    this.removeReceiver(receiver.pos);
                    return;
                }
                if (!this.updateDevice(receiver)) {
                    this.removeReceiver(receiver.pos);
                    return;
                }
                if (receiver.timeOut != 0) continue;
                moveToFast.add(receiver);
            }
            if (!moveToFast.isEmpty()) {
                this.fastList.addAll(moveToFast);
                this.slowList.removeAll(moveToFast);
            }
        }
        if (!moveToSlow.isEmpty()) {
            this.slowList.addAll(moveToSlow);
            this.fastList.removeAll(moveToSlow);
        }
        if (!this.field_145850_b.field_72995_K && DEEventHandler.serverTicks % 10 == 0) {
            this.receiverFlowRates.clear();
            for (int i = 0; i < this.linkedReceivers.size(); ++i) {
                this.receiverFlowRates.add(this.flowConversion(this.receiverTransfer(i)));
            }
        }
    }

    @Override
    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return true;
    }

    protected boolean updateDevice(LinkedDevice receiver) {
        int transfered;
        if (!receiver.isLinkValid(this.field_145850_b)) {
            return receiver.invalidTime++ < 100;
        }
        receiver.invalidTime = 0;
        TileEntity tile = receiver.getCachedTile();
        if (tile == null) {
            receiver.timeOut = receiver.timeOut < 40 ? 40 : ++receiver.timeOut;
            return true;
        }
        if (this.inputMode.value) {
            transfered = EnergyHelper.extractEnergy((TileEntity)tile, (int)this.energyStorage.receiveEnergy(this.getMaxWirelessTransfer(), true), (EnumFacing)receiver.side, (boolean)false);
            this.energyStorage.receiveEnergy(transfered, false);
        } else {
            this.energyStorage.extractEnergy(5000, false);
            transfered = EnergyHelper.insertEnergy((TileEntity)tile, (int)this.energyStorage.extractEnergy(this.getMaxWirelessTransfer(), true), (EnumFacing)receiver.side, (boolean)false);
            this.energyStorage.extractEnergy(transfered, false);
        }
        receiver.timeOut = transfered > 0 ? 0 : ++receiver.timeOut;
        this.receiverTransferRates.get((int)receiver.index)[this.tick % 20] = transfered;
        return true;
    }

    public void rebuildReceiverTransferList() {
        this.receiverTransferRates.clear();
        this.receiverFlowRates.clear();
        for (int i = 0; i < this.linkedReceivers.size(); ++i) {
            this.receiverTransferRates.add(new int[20]);
            this.receiverFlowRates.add((byte)0);
        }
    }

    public int getMaxWirelessTransfer() {
        return 1000000;
    }

    public int receiverTransfer(int index) {
        long sum = 0L;
        for (int transfer : this.receiverTransferRates.get(index)) {
            sum += (long)transfer;
        }
        return (int)(sum / 20L);
    }

    public byte flowConversion(int transferRate) {
        double d = (double)transferRate / ((double)this.getMaxWirelessTransfer() * 0.01 + (double)transferRate);
        return (byte)(d * 255.0);
    }

    @Override
    public boolean binderUsed(EntityPlayer player, BlockPos linkTarget, EnumFacing sideClicked) {
        return false;
    }

    public List<BlockPos> getReceivers() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverCache;
    }

    public Map<BlockPos, EnumFacing> getReceiversFaces() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size() || this.receiverFaceCache == null || this.receiverFaceCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverFaceCache;
    }

    public int getMaxReceivers() {
        return 3375;
    }

    private void reCachePositions() {
        this.receiverCache = new LinkedList();
        this.receiverFaceCache = new HashMap<BlockPos, EnumFacing>();
        this.fastList.clear();
        this.slowList.clear();
        for (Vec3B offset : this.linkedReceivers) {
            this.receiverCache.add(this.fromOffset(offset));
            this.receiverFaceCache.put(this.fromOffset(offset), this.receiverSideMap.get(offset));
            this.fastList.add(new LinkedDevice(this.linkedReceivers.indexOf(offset), this.fromOffset(offset), this.receiverSideMap.get(offset)));
        }
        this.updateBlock();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrystalGLFXBase createStaticFX() {
        return new CrystalFXRing(this.field_145850_b, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        Vec3D thisVec = Vec3D.getCenter((BlockPos)this.field_174879_c);
        Vec3D targVec = Vec3D.getCenter((BlockPos)linkTo);
        double dist = thisVec.distXZ(targVec);
        double offM = 0.4;
        if (dist == 0.0) {
            if (this.field_174879_c.func_177956_o() > linkTo.func_177956_o()) {
                return thisVec.subtract(0.0, 0.4, 0.0);
            }
            return thisVec.subtract(0.0, -0.4, 0.0);
        }
        double xDist = thisVec.x - targVec.x;
        double zDist = thisVec.z - targVec.z;
        double xOff = xDist / dist;
        double zOff = zDist / dist;
        return thisVec.subtract(xOff * offM, 0.0, zOff * offM);
    }

    @Override
    public boolean renderBeamTermination() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(List<String> displayList) {
        super.addDisplayData(displayList);
        displayList.add(TextFormatting.GREEN + I18n.func_135052_a((String)"eNet.de.hudWirelessLinks.info", (Object[])new Object[0]) + ": " + this.getReceivers().size() + " / " + this.getMaxReceivers());
        TextFormatting colour = !this.inputMode.value ? TextFormatting.GOLD : TextFormatting.DARK_AQUA;
        displayList.add(I18n.func_135052_a((String)("eNet.de.IOOutput_" + !this.inputMode.value + ".info"), (Object[])new Object[]{colour}));
    }

    private boolean isValidReceiver(TileEntity te) {
        return te != null && !EXCLUDED_TILE_ENTITIES.contains(te.getClass());
    }

    public void addReceiver(BlockPos pos, EnumFacing side) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (!this.isValidReceiver(te)) {
            return;
        }
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.add(offset);
        this.receiverSideMap.put(offset, side);
        this.reCachePositions();
        this.updateBlock();
    }

    public void removeReceiver(BlockPos pos) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.remove(offset);
        this.receiverSideMap.remove(offset);
        this.reCachePositions();
        this.updateBlock();
    }

    @Override
    public void detectAndSendContainerChanges(List<IContainerListener> listeners) {
        super.detectAndSendContainerChanges(listeners);
        if (this.linkedReceivers.size() != this.receiverTransferRates.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildReceiverTransferList();
        }
        List<BlockPos> positions = this.getReceivers();
        NBTTagList list = new NBTTagList();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerReceiverFlow.containsKey(index) && this.containerReceiverFlow.get(index).intValue() == this.receiverTransfer(index)) continue;
            this.containerReceiverFlow.put(index, this.receiverTransfer(index));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("I", (byte)index);
            data.func_74768_a("E", this.receiverTransfer(index));
            list.func_74742_a((NBTBase)data);
        }
        NBTTagCompound compound = new NBTTagCompound();
        if (!list.func_82582_d()) {
            compound.func_74782_a("L", (NBTBase)list);
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeNBTTagCompound(compound), 1));
        } else if (this.containerReceiverFlow.size() > this.linkedReceivers.size()) {
            this.containerReceiverFlow.clear();
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeNBTTagCompound(compound), 1));
        }
    }

    @Override
    public void receivePacketFromServer(MCDataInput data, int id) {
        super.receivePacketFromServer(data, id);
        if (id == 1) {
            NBTTagCompound compound = data.readNBTTagCompound();
            NBTTagList list = compound.func_150295_c("L", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tagData = list.func_150305_b(i);
                this.containerReceiverFlow.put(Integer.valueOf(tagData.func_74771_c("I")), tagData.func_74762_e("E"));
            }
        }
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 11) {
            int intValue = data.readInt();
            if (this.getReceivers().size() > intValue && intValue >= 0) {
                BlockPos target = this.getReceivers().get(intValue);
                this.removeReceiver(target);
            }
        } else if (id == 21) {
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getReceivers());
            for (BlockPos target : links) {
                this.removeReceiver(target);
            }
        }
    }

    static {
        EXCLUDED_TILE_ENTITIES.add(TileFluxPoint.class);
        EXCLUDED_TILE_ENTITIES.add(TileFluxPlug.class);
        EXCLUDED_TILE_ENTITIES.add(TileEntityEnergyCube.class);
        EXCLUDED_TILE_ENTITIES.add(TileEntityGenerator.class);
        EXCLUDED_TILE_ENTITIES.add(TileEntityInductionCasing.class);
        EXCLUDED_TILE_ENTITIES.add(TileEntityInductionCell.class);
    }

    private class LinkedDevice {
        public final int index;
        public final BlockPos pos;
        private final EnumFacing side;
        public int timeOut = 0;
        private TileEntity tileCache = null;
        private int invalidTime = 0;

        public LinkedDevice(int index, BlockPos pos, EnumFacing side) {
            this.index = index;
            this.pos = pos;
            this.side = side;
        }

        public boolean isLinkValid(World world) {
            this.tileCache = world.func_175625_s(this.pos);
            return this.tileCache != null && EnergyHelper.isEnergyTile((TileEntity)this.tileCache, (EnumFacing)this.side) || !world.func_175726_f(this.pos).func_177410_o();
        }

        public TileEntity getCachedTile() {
            return this.tileCache;
        }
    }
}

