/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;

public final class TypeUtil {
    @Contract(value="null, _ -> null; !null, true -> _; !null, false -> !null")
    @Nullable
    public static List<String> splitTypes(@Nullable String signature, boolean isSignature) {
        String type;
        if (signature == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (int pos = 0; pos < signature.length(); pos += type.length()) {
            type = TypeUtil.readType(signature, pos, isSignature);
            types.add(type);
        }
        if (isSignature && types.isEmpty()) {
            return null;
        }
        return types;
    }

    public static Stream<String> readTypes(final @NonNull String in, final boolean isSignature) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        return CollectionUtil.stream(new Supplier<String>(){
            int pos = 0;

            @Override
            @Nullable
            public String get() {
                if (this.pos < in.length()) {
                    String next = TypeUtil.readType(in, this.pos, isSignature);
                    this.pos += next.length();
                    return next;
                }
                return null;
            }
        });
    }

    public static String readType(String in, int pos, boolean isSignature) {
        int startPos = pos;
        String arrayLevel = "";
        block11: while (pos < in.length()) {
            char c = in.charAt(pos++);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    return arrayLevel + c;
                }
                case '[': {
                    arrayLevel = arrayLevel + '[';
                    continue block11;
                }
                case 'T': {
                    int end = in.indexOf(59, pos);
                    String name = in.substring(pos, end);
                    return arrayLevel + 'T' + name + ';';
                }
                case 'L': {
                    int start = pos;
                    int genericCount = 0;
                    while (pos < in.length()) {
                        switch (in.charAt(pos++)) {
                            case ';': {
                                if (genericCount > 0) break;
                                String name = in.substring(start, pos);
                                return arrayLevel + 'L' + name;
                            }
                            case '<': {
                                if (!isSignature) {
                                    throw new TransformationException("Illegal character '<' in descriptor: " + in);
                                }
                                ++genericCount;
                                break;
                            }
                            case '>': {
                                --genericCount;
                            }
                        }
                    }
                    continue block11;
                }
            }
            throw new TransformationException("Unexpected character '" + c + "' in signature/descriptor '" + in + "' Searched section '" + in.substring(startPos, pos) + "'");
        }
        throw new StringIndexOutOfBoundsException("Reached " + pos + " in " + in);
    }

    private TypeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

