/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public final class Cloner {
    public static FieldNode clone(FieldNode other) {
        FieldNode node = new FieldNode(other.access, other.name, other.desc, other.signature, other.value);
        node.attrs = other.attrs;
        node.invisibleAnnotations = other.invisibleAnnotations;
        node.invisibleTypeAnnotations = other.invisibleTypeAnnotations;
        node.visibleAnnotations = other.visibleAnnotations;
        node.visibleTypeAnnotations = other.visibleTypeAnnotations;
        return node;
    }

    public static MethodNode clone(MethodNode other) {
        MethodNode node = new MethodNode();
        node.desc = other.desc;
        node.signature = other.signature;
        node.access = other.access;
        node.name = other.name;
        node.attrs = other.attrs;
        node.maxLocals = other.maxLocals;
        node.maxStack = other.maxStack;
        node.annotationDefault = other.annotationDefault;
        node.exceptions = other.exceptions;
        node.instructions = other.instructions;
        node.invisibleAnnotations = other.invisibleAnnotations;
        node.invisibleLocalVariableAnnotations = other.invisibleLocalVariableAnnotations;
        node.invisibleParameterAnnotations = other.invisibleParameterAnnotations;
        node.invisibleTypeAnnotations = other.invisibleTypeAnnotations;
        node.visibleAnnotations = other.visibleAnnotations;
        node.visibleLocalVariableAnnotations = other.visibleLocalVariableAnnotations;
        node.visibleParameterAnnotations = other.visibleParameterAnnotations;
        node.visibleTypeAnnotations = other.visibleTypeAnnotations;
        node.localVariables = other.localVariables;
        node.tryCatchBlocks = other.tryCatchBlocks;
        return node;
    }

    public static MethodNode deepClone(MethodNode other) {
        MethodNode node = new MethodNode();
        node.desc = other.desc;
        node.signature = other.signature;
        node.access = other.access;
        node.name = other.name;
        node.attrs = Cloner.clone(other.attrs);
        node.maxLocals = other.maxLocals;
        node.maxStack = other.maxStack;
        node.annotationDefault = other.annotationDefault;
        node.exceptions = Cloner.clone(other.exceptions);
        node.instructions = other.instructions;
        node.invisibleAnnotations = Cloner.clone(other.invisibleAnnotations);
        node.invisibleLocalVariableAnnotations = Cloner.clone(other.invisibleLocalVariableAnnotations);
        node.invisibleParameterAnnotations = Cloner.clone(other.invisibleParameterAnnotations);
        node.invisibleTypeAnnotations = Cloner.clone(other.invisibleTypeAnnotations);
        node.visibleAnnotations = Cloner.clone(other.visibleAnnotations);
        node.visibleLocalVariableAnnotations = Cloner.clone(other.visibleLocalVariableAnnotations);
        node.visibleParameterAnnotations = Cloner.clone(other.visibleParameterAnnotations);
        node.visibleTypeAnnotations = Cloner.clone(other.visibleTypeAnnotations);
        node.localVariables = Cloner.clone(other.localVariables);
        node.tryCatchBlocks = Cloner.clone(other.tryCatchBlocks);
        return node;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    private static <T> ArrayList<T> clone(@Nullable List<T> list) {
        return list == null ? null : new ArrayList<T>(list);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    private static <T> ArrayList<T>[] clone(@Nullable List<T>[] lists) {
        if (lists == null) {
            return null;
        }
        List[] newList = new List[lists.length];
        for (int i = 0; i < lists.length; ++i) {
            newList[i] = Cloner.clone(lists[i]);
        }
        return (ArrayList[])newList;
    }

    public static InsnList clone(InsnList list) {
        return Cloner.clone(list, list.getFirst(), list.getLast());
    }

    public static InsnList clone(final @NonNull InsnList list, final @Nullable AbstractInsnNode first, final @Nullable AbstractInsnNode last) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        InsnList cloned = new InsnList();
        if (first == null && last == null) {
            return cloned;
        }
        if (first == null || last == null) {
            throw new NullPointerException();
        }
        HashMap<LabelNode, LabelNode> labels = new HashMap<LabelNode, LabelNode>(){

            @Override
            public LabelNode get(Object key) {
                LabelNode result = (LabelNode)super.get(key);
                if (result == null) {
                    throw new TransformationException("Label " + key + " referenced by copied instruction in " + list + " is out of bounds to be copied " + first + "->" + last);
                }
                return result;
            }
        };
        AbstractInsnNode insn = first;
        while (true) {
            if (insn instanceof LabelNode) {
                labels.put((LabelNode)insn, new LabelNode());
            }
            if (insn == last) break;
            insn = insn.getNext();
        }
        insn = first;
        while (true) {
            cloned.add(insn.clone((Map)labels));
            if (insn == last) break;
            insn = insn.getNext();
        }
        return cloned;
    }

    private Cloner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

