/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class CachingSupplier<T>
implements Supplier<T> {
    @NonNull
    private final Supplier<T> wrapped;
    private transient T value;

    protected CachingSupplier(Supplier<T> wrapped) {
        this.wrapped = wrapped;
    }

    public static <T> CachingSupplier<T> of(Supplier<T> wrapped) {
        return new CachingSupplier<T>(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T value = this.value;
        if (value == null) {
            CachingSupplier cachingSupplier = this;
            synchronized (cachingSupplier) {
                if (this.value == null) {
                    this.value = value = Objects.requireNonNull(this.wrapped.get());
                }
            }
        }
        return value;
    }

    public void set(@Nullable T value) {
        this.value = value;
    }

    public boolean isCached() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachingSupplier)) {
            return false;
        }
        CachingSupplier other = (CachingSupplier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<T> this$wrapped = this.wrapped;
        Supplier<T> other$wrapped = other.wrapped;
        return !(this$wrapped == null ? other$wrapped != null : !this$wrapped.equals(other$wrapped));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachingSupplier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<T> $wrapped = this.wrapped;
        result = result * 59 + ($wrapped == null ? 43 : $wrapped.hashCode());
        return result;
    }

    public String toString() {
        return "CachingSupplier(wrapped=" + this.wrapped + ", value=" + this.value + ")";
    }
}

