/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.minimallycorrect.javatransformer.api.AccessFlags;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.ClassInfo;
import org.minimallycorrect.javatransformer.api.FieldInfo;
import org.minimallycorrect.javatransformer.api.MethodInfo;
import org.minimallycorrect.javatransformer.api.Parameter;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.TypeVariable;
import org.minimallycorrect.javatransformer.api.code.CodeFragment;
import org.minimallycorrect.javatransformer.internal.AsmCodeFragmentGenerator;
import org.minimallycorrect.javatransformer.internal.MethodDescriptor;
import org.minimallycorrect.javatransformer.internal.SimpleFieldInfo;
import org.minimallycorrect.javatransformer.internal.SimpleMethodInfo;
import org.minimallycorrect.javatransformer.internal.asm.CombinedAnalyzer;
import org.minimallycorrect.javatransformer.internal.asm.CombinedInterpreter;
import org.minimallycorrect.javatransformer.internal.asm.CombinedValue;
import org.minimallycorrect.javatransformer.internal.asm.FilteringClassWriter;
import org.minimallycorrect.javatransformer.internal.util.AnnotationParser;
import org.minimallycorrect.javatransformer.internal.util.CachingSupplier;
import org.minimallycorrect.javatransformer.internal.util.Cloner;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;

public class ByteCodeInfo
implements ClassInfo {
    private final Supplier<ClassNode> node;
    private final AtomicReference<Object> annotations = new AtomicReference();
    public boolean hasChangedMethodControlFlow;
    @NonNull
    private String className;
    @NonNull
    private Map<String, String> filters;

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public void setName(String name) {
        this.className = name;
        this.node.get().name = name.replace('.', '/');
    }

    @Override
    public AccessFlags getAccessFlags() {
        return new AccessFlags(this.node.get().access);
    }

    @Override
    public void setAccessFlags(AccessFlags accessFlags) {
        this.node.get().access = accessFlags.access;
    }

    @Override
    public void add(MethodInfo method) {
        MethodNode node;
        if (method instanceof MethodNodeInfo) {
            MethodNodeInfo orig = (MethodNodeInfo)method;
            node = Cloner.clone(orig.node);
            FilteringClassWriter.addFilter(this.filters, orig.getClassInfo().getName(), this.getName());
        } else {
            node = new MethodNode();
            node.desc = "()V";
            node.exceptions = new ArrayList();
            MethodNodeInfo info = new MethodNodeInfo(node);
            info.setAll(method);
        }
        this.node.get().methods.add(node);
    }

    @Override
    public void add(FieldInfo field) {
        FieldNode node;
        if (field instanceof FieldNodeInfo) {
            node = Cloner.clone(((FieldNodeInfo)field).node);
        } else {
            node = new FieldNode(0, null, "V", null, null);
            FieldNodeInfo nodeInfo = new FieldNodeInfo(node);
            nodeInfo.setAll(field);
        }
        this.node.get().fields.add(node);
    }

    @Override
    public void remove(MethodInfo method) {
        MethodNodeInfo methodNodeInfo;
        MethodNodeInfo methodNodeInfo2 = methodNodeInfo = !(method instanceof MethodNodeInfo) ? (MethodNodeInfo)this.get(method) : (MethodNodeInfo)method;
        if (methodNodeInfo == null) {
            throw new TransformationException("Method " + method + " can not be removed as it is not present");
        }
        this.node.get().methods.remove(methodNodeInfo.node);
    }

    @Override
    public void remove(FieldInfo field) {
        FieldNodeInfo fieldNodeInfo;
        FieldNodeInfo fieldNodeInfo2 = fieldNodeInfo = !(field instanceof FieldNodeInfo) ? (FieldNodeInfo)this.get(field) : (FieldNodeInfo)field;
        if (fieldNodeInfo == null) {
            throw new TransformationException("Field " + field + " can not be removed as it is not present");
        }
        this.node.get().fields.remove(fieldNodeInfo.node);
    }

    @Override
    public Type getSuperType() {
        return new Type("L" + this.node.get().superName + ";");
    }

    @Override
    public List<Type> getInterfaceTypes() {
        return this.node.get().interfaces.stream().map(it -> new Type("L" + it + ";")).collect(Collectors.toList());
    }

    @Override
    public Stream<MethodInfo> getMethods() {
        return this.node.get().methods.stream().map(x$0 -> new MethodNodeInfo((MethodNode)x$0));
    }

    @Override
    public Stream<FieldInfo> getFields() {
        return this.node.get().fields.stream().map(x$0 -> new FieldNodeInfo((FieldNode)x$0));
    }

    private List<Annotation> getAnnotationsInternal() {
        Stream<AnnotationNode> allAnnotationNodes = CollectionUtil.union(this.node.get().invisibleAnnotations, this.node.get().visibleAnnotations);
        Stream<Annotation> stream = allAnnotationNodes.map(it -> AnnotationParser.annotationFromAnnotationNode(it));
        return stream.collect(Collectors.toList());
    }

    @Override
    public ClassInfo getClassInfo() {
        return this;
    }

    MethodNodeInfo wrap(MethodNode node) {
        return new MethodNodeInfo(node);
    }

    public ByteCodeInfo(Supplier<ClassNode> node, @NonNull String className, @NonNull Map<String, String> filters) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (filters == null) {
            throw new NullPointerException("filters");
        }
        this.node = node;
        this.className = className;
        this.filters = filters;
    }

    public Supplier<ClassNode> getNode() {
        return this.node;
    }

    public boolean isHasChangedMethodControlFlow() {
        return this.hasChangedMethodControlFlow;
    }

    @NonNull
    public String getClassName() {
        return this.className;
    }

    @NonNull
    public Map<String, String> getFilters() {
        return this.filters;
    }

    public void setHasChangedMethodControlFlow(boolean hasChangedMethodControlFlow) {
        this.hasChangedMethodControlFlow = hasChangedMethodControlFlow;
    }

    public void setClassName(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        this.className = className;
    }

    public void setFilters(@NonNull Map<String, String> filters) {
        if (filters == null) {
            throw new NullPointerException("filters");
        }
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteCodeInfo)) {
            return false;
        }
        ByteCodeInfo other = (ByteCodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<ClassNode> this$node = this.getNode();
        Supplier<ClassNode> other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        if (this.isHasChangedMethodControlFlow() != other.isHasChangedMethodControlFlow()) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Map<String, String> this$filters = this.getFilters();
        Map<String, String> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteCodeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<ClassNode> $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        result = result * 59 + (this.isHasChangedMethodControlFlow() ? 79 : 97);
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Map<String, String> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "ByteCodeInfo(node=" + this.getNode() + ", annotations=" + this.getAnnotations() + ", hasChangedMethodControlFlow=" + this.isHasChangedMethodControlFlow() + ", className=" + this.getClassName() + ", filters=" + this.getFilters() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Annotation> getAnnotations() {
        Object value = this.annotations.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.annotations;
            synchronized (atomicReference) {
                value = this.annotations.get();
                if (value == null) {
                    List<Annotation> actualValue = this.getAnnotationsInternal();
                    value = actualValue == null ? this.annotations : actualValue;
                    this.annotations.set(value);
                }
            }
        }
        return (List)(value == this.annotations ? null : value);
    }

    public class MethodNodeInfo
    implements MethodInfo {
        public final MethodNode node;
        private final CachingSupplier<Frame<CombinedValue>[]> stackFrames;
        private CachingSupplier<MethodDescriptor> descriptor;
        private CachingSupplier<CodeFragment.Body> codeFragment;

        MethodNodeInfo(MethodNode node) {
            this.node = node;
            this.descriptor = CachingSupplier.of(() -> {
                try {
                    return new MethodDescriptor(node);
                }
                catch (TransformationException e) {
                    throw new TransformationException("Failed to parse method parameters in " + node.name + ':' + "\n\tname: " + node.name + "\n\tdescriptor: " + node.desc + "\n\tsignature:" + node.signature, e);
                }
            });
            this.codeFragment = CachingSupplier.of(() -> new AsmCodeFragmentGenerator.MethodNodeInfoCodeFragment(this));
            this.stackFrames = CachingSupplier.of(this::analyzeStackFrames);
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.node.access);
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.node.access = accessFlags.access;
        }

        @Override
        public String getName() {
            return this.node.name;
        }

        @Override
        public void setName(String name) {
            this.node.name = name;
        }

        @Override
        public Type getReturnType() {
            return this.descriptor.get().getReturnType();
        }

        @Override
        public void setReturnType(Type returnType) {
            this.descriptor.set(this.descriptor.get().withReturnType(returnType));
            this.descriptor.get().saveTo(this.node);
        }

        @Override
        public List<Parameter> getParameters() {
            return this.descriptor.get().getParameters();
        }

        @Override
        public void setParameters(List<Parameter> parameters) {
            this.descriptor.set(this.descriptor.get().withParameters(parameters));
            this.descriptor.get().saveTo(this.node);
        }

        public String getDescriptor() {
            return this.descriptor.get().getDescriptor();
        }

        @Override
        public List<Annotation> getAnnotations() {
            return CollectionUtil.union(this.node.invisibleAnnotations, this.node.visibleAnnotations).map(AnnotationParser::annotationFromAnnotationNode).collect(Collectors.toList());
        }

        @Override
        public ByteCodeInfo getClassInfo() {
            return ByteCodeInfo.this;
        }

        public String toString() {
            return SimpleMethodInfo.toString(this);
        }

        @Override
        public List<TypeVariable> getTypeVariables() {
            return this.descriptor.get().getTypeVariables();
        }

        @Override
        public void setTypeVariables(List<TypeVariable> typeVariables) {
            this.descriptor.set(this.descriptor.get().withTypeVariables(typeVariables));
            this.descriptor.get().saveTo(this.node);
        }

        @Override
        public MethodInfo clone() {
            return new MethodNodeInfo(Cloner.clone(this.node));
        }

        @Override
        @NonNull
        public CodeFragment.Body getCodeFragment() {
            return this.codeFragment.get();
        }

        public Frame<CombinedValue>[] getStackFrames() {
            return this.stackFrames.get();
        }

        private Frame<CombinedValue>[] analyzeStackFrames() {
            return CombinedAnalyzer.analyze(new CombinedInterpreter(), this.getClassInfo().getNode().get().name, this.node);
        }

        public void markCodeDirty() {
            this.stackFrames.set(null);
            ByteCodeInfo.this.hasChangedMethodControlFlow = true;
        }
    }

    public class FieldNodeInfo
    implements FieldInfo {
        final FieldNode node;
        private Type type;

        FieldNodeInfo(FieldNode node) {
            this.node = node;
            this.type = new Type(node.desc, node.signature);
        }

        @Override
        public String getName() {
            return this.node.name;
        }

        @Override
        public void setName(String name) {
            this.node.name = name;
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.node.access);
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.node.access = accessFlags.access;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public void setType(Type type) {
            this.type = type;
            this.node.desc = type.descriptor;
            this.node.signature = type.signature;
        }

        @Override
        public List<Annotation> getAnnotations() {
            return CollectionUtil.union(this.node.invisibleAnnotations, this.node.visibleAnnotations).map(AnnotationParser::annotationFromAnnotationNode).collect(Collectors.toList());
        }

        @Override
        public ClassInfo getClassInfo() {
            return ByteCodeInfo.this;
        }

        public String toString() {
            return SimpleFieldInfo.toString(this);
        }

        @Override
        public FieldInfo clone() {
            return new FieldNodeInfo(Cloner.clone(this.node));
        }
    }
}

