/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.minimallycorrect.javatransformer.api.Parameter;
import org.minimallycorrect.javatransformer.api.code.CodeFragment;
import org.minimallycorrect.javatransformer.api.code.IntermediateValue;
import org.minimallycorrect.javatransformer.api.code.RETURN;
import org.minimallycorrect.javatransformer.internal.ByteCodeInfo;
import org.minimallycorrect.javatransformer.internal.MethodDescriptor;
import org.minimallycorrect.javatransformer.internal.asm.AsmInstructions;
import org.minimallycorrect.javatransformer.internal.asm.CombinedValue;
import org.minimallycorrect.javatransformer.internal.asm.DebugPrinter;
import org.minimallycorrect.javatransformer.internal.util.Cloner;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Frame;

class AsmCodeFragmentGenerator
implements Opcodes {
    AsmCodeFragmentGenerator() {
    }

    static Class<?> concreteImplementation(Class<?> interfaceType) {
        if (interfaceType == CodeFragment.class) {
            return MethodNodeInfoCodeFragment.class;
        }
        if (interfaceType == CodeFragment.MethodCall.class) {
            return MethodCall.class;
        }
        if (interfaceType == CodeFragment.FieldAccess.class) {
            return CodeFragment.FieldAccess.class;
        }
        throw new UnsupportedOperationException("No ASM implementation for " + interfaceType);
    }

    private static boolean ivEqualIgnoringStackOffset(IntermediateValue t, IntermediateValue t1) {
        return t.type.equals(t1.type) && t.location.type.equals((Object)t1.location.type);
    }

    static class MethodCall
    extends InstructionCodeFragment
    implements CodeFragment.MethodCall {
        private final MethodInsnNode instruction;

        public MethodCall(ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo, MethodInsnNode instruction) {
            super(containingMethodNodeInfo);
            this.instruction = instruction;
        }

        @Override
        @NonNull
        public org.minimallycorrect.javatransformer.api.Type getContainingClassType() {
            return new org.minimallycorrect.javatransformer.api.Type('L' + this.instruction.owner + ';');
        }

        @Override
        @NonNull
        public String getName() {
            return this.instruction.name;
        }

        public MethodInsnNode getInstruction() {
            return this.instruction;
        }
    }

    static class MethodNodeInfoCodeFragment
    extends AsmCodeFragment
    implements CodeFragment.Body {
        MethodNodeInfoCodeFragment(ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo) {
            super(containingMethodNodeInfo);
        }

        @Override
        protected void setUsedLocalIndexes(BitSet set) {
            int i = 0;
            if (!this.containingMethodNodeInfo.getAccessFlags().has(8)) {
                set.set(i++);
            }
            set.set(i, i + this.containingMethodNodeInfo.getParameters().size());
            if (i > this.containingMethodNodeInfo.node.maxLocals) {
                throw new IllegalStateException();
            }
        }

        @Override
        @NonNull
        public AbstractInsnNode getFirstInstruction() {
            return this.containingMethodNodeInfo.node.instructions.getFirst();
        }

        @Override
        @NonNull
        public AbstractInsnNode getLastInstruction() {
            return this.containingMethodNodeInfo.node.instructions.getLast();
        }
    }

    static abstract class InstructionCodeFragment
    extends AsmCodeFragment {
        InstructionCodeFragment(ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo) {
            super(containingMethodNodeInfo);
        }

        public abstract AbstractInsnNode getInstruction();

        @Override
        @NonNull
        public final AbstractInsnNode getFirstInstruction() {
            return this.getInstruction();
        }

        @Override
        @NonNull
        public final AbstractInsnNode getLastInstruction() {
            return this.getInstruction();
        }
    }

    static abstract class AsmCodeFragment
    implements CodeFragment {
        @NonNull
        public final ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo;

        @NonNull
        public abstract AbstractInsnNode getFirstInstruction();

        @NonNull
        public abstract AbstractInsnNode getLastInstruction();

        @Override
        public CodeFragment.ExecutionOutcome getExecutionOutcome() {
            boolean canFallThroughThisInstruction;
            AbstractInsnNode current = this.getFirstInstruction();
            AbstractInsnNode last = this.getLastInstruction();
            Frame<CombinedValue>[] frames = this.containingMethodNodeInfo.getStackFrames();
            boolean canThrow = false;
            boolean canReturn = false;
            InsnList list = this.containingMethodNodeInfo.node.instructions;
            while (true) {
                canFallThroughThisInstruction = false;
                if (frames[list.indexOf(current)] != null) {
                    switch (current.getOpcode()) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            canReturn = true;
                            break;
                        }
                        case 191: {
                            canThrow = true;
                            break;
                        }
                        case 167: {
                            break;
                        }
                        default: {
                            canFallThroughThisInstruction = true;
                        }
                    }
                }
                if (current == last) break;
                current = current.getNext();
            }
            boolean canFallThrough = canFallThroughThisInstruction;
            if (!(canFallThrough || canThrow || canReturn)) {
                throw new IllegalStateException("canFallThrough canThrow and canReturn all false for " + this + ", impossible execution outcome");
            }
            return new CodeFragment.ExecutionOutcome(canFallThrough, canThrow, canReturn);
        }

        @Override
        @NonNull
        public List<IntermediateValue> getInputTypes() {
            return this.getTypes(true, true, true);
        }

        @Override
        @NonNull
        public List<IntermediateValue> getOutputTypes() {
            return this.getTypes(false, true, true);
        }

        List<IntermediateValue> getTypes(boolean inputs, boolean stack, boolean locals) {
            AbstractInsnNode first = this.getFirstInstruction();
            AbstractInsnNode last = this.getLastInstruction();
            MethodNode node = this.containingMethodNodeInfo.node;
            InsnList insnList = node.instructions;
            Object[] frames = this.containingMethodNodeInfo.getStackFrames();
            int startIndex = insnList.indexOf(first);
            int endIndex = insnList.indexOf(last) + 1;
            ArrayList<IntermediateValue> results = new ArrayList<IntermediateValue>();
            if (locals && inputs) {
                CombinedValue local;
                Object frame;
                BitSet usedLocals = new BitSet(node.maxLocals);
                AbstractInsnNode insn = first;
                while (true) {
                    int opcode;
                    if ((opcode = insn.getOpcode()) >= 21 && opcode < 46 || insn instanceof VarInsnNode) {
                        VarInsnNode varInsnNode = (VarInsnNode)insn;
                        int target = varInsnNode.var;
                        frame = frames[insnList.indexOf(insn)];
                        local = (CombinedValue)frame.getLocal(target);
                        if (local.isPrefilled() || !local.isInitialised()) {
                            usedLocals.set(target);
                        }
                    }
                    if (insn == last) break;
                    insn = insn.getNext();
                }
                this.setUsedLocalIndexes(usedLocals);
                for (int i = 0; i < usedLocals.size(); ++i) {
                    if (!usedLocals.get(i)) continue;
                    Type type = null;
                    for (int j = startIndex; j <= endIndex; ++j) {
                        frame = frames[j];
                        local = (CombinedValue)frame.getLocal(i);
                        if (!local.isInitialised()) continue;
                        type = local.getType();
                        break;
                    }
                    if (type == null) {
                        type = CombinedValue.OBJECT_TYPE;
                    }
                    results.add(new IntermediateValue(new org.minimallycorrect.javatransformer.api.Type(type.getDescriptor()), IntermediateValue.UNKNOWN, new IntermediateValue.Location(IntermediateValue.LocationType.LOCAL, i, null)));
                }
            }
            if (stack) {
                int ls;
                Frame<CombinedValue> lastFrame;
                Frame<CombinedValue> firstFrame = frames[startIndex];
                Frame<CombinedValue> frame = lastFrame = endIndex >= frames.length ? null : frames[endIndex];
                if (!inputs) {
                    Frame<CombinedValue> temp = firstFrame;
                    firstFrame = lastFrame;
                    lastFrame = temp;
                }
                int fs = firstFrame == null ? 0 : firstFrame.getStackSize();
                int n = ls = lastFrame == null ? 0 : lastFrame.getStackSize();
                if (firstFrame == null && lastFrame == null) {
                    DebugPrinter.printByteCode(this.containingMethodNodeInfo.node, "unexpected_null_frame");
                    throw new IllegalStateException("frames were unreachable " + Arrays.toString(frames));
                }
                for (int i = 0; i < fs; ++i) {
                    CombinedValue origStackValue = i < ls ? (CombinedValue)lastFrame.getStack(i) : null;
                    CombinedValue stackValue = (CombinedValue)firstFrame.getStack(i);
                    if (Objects.equals(stackValue, origStackValue)) continue;
                    assert (stackValue.getType() != null);
                    results.add(new IntermediateValue(new org.minimallycorrect.javatransformer.api.Type(stackValue.getType().getDescriptor()), stackValue.getConstantValue(), new IntermediateValue.Location(IntermediateValue.LocationType.STACK, i, null)));
                }
            }
            return results;
        }

        protected void setUsedLocalIndexes(BitSet usedLocals) {
        }

        @Override
        public void insert(@NonNull CodeFragment fragmentOfAnyType, @NonNull CodeFragment.InsertionPosition position, @NonNull CodeFragment.InsertionOptions insertionOptions) {
            if (fragmentOfAnyType == null) {
                throw new NullPointerException("fragmentOfAnyType");
            }
            if (position == null) {
                throw new NullPointerException("position");
            }
            if (insertionOptions == null) {
                throw new NullPointerException("insertionOptions");
            }
            if (this.equals(fragmentOfAnyType)) {
                if (position == CodeFragment.InsertionPosition.OVERWRITE) {
                    return;
                }
                throw new UnsupportedOperationException("Can't insert a CodeFragment into itself");
            }
            if (!(fragmentOfAnyType instanceof AsmCodeFragment)) {
                throw new CodeFragment.TypeMismatchException(AsmCodeFragment.class, fragmentOfAnyType);
            }
            AsmCodeFragment fragment = (AsmCodeFragment)fragmentOfAnyType;
            ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo = this.containingMethodNodeInfo;
            MethodNode containingMethodNode = containingMethodNodeInfo.node;
            InsnList containingList = containingMethodNode.instructions;
            AbstractInsnNode first = this.getFirstInstruction();
            AbstractInsnNode last = this.getLastInstruction();
            CodeFragment.ExecutionOutcome executionResult = this.getExecutionOutcome();
            if (!executionResult.canFallThrough && position == CodeFragment.InsertionPosition.AFTER) {
                throw new CodeFragment.UnreachableInsertionException(this, CodeFragment.InsertionPosition.AFTER);
            }
            InsnList insertInstructions = Cloner.clone(fragment.containingMethodNodeInfo.node.instructions, fragment.getFirstInstruction(), fragment.getLastInstruction());
            MethodNode clonedMethod = Cloner.deepClone(fragment.containingMethodNodeInfo.node);
            clonedMethod.instructions = insertInstructions;
            clonedMethod.name = clonedMethod.name + "_mod";
            fragment = new MethodNodeInfoCodeFragment(containingMethodNodeInfo.getClassInfo().wrap(clonedMethod));
            DebugPrinter.printByteCode(clonedMethod, "base");
            this.applyInsertionOptions((MethodNodeInfoCodeFragment)fragment, insertionOptions);
            DebugPrinter.printByteCode(clonedMethod, "insertionOptions");
            this.convertTypes((MethodNodeInfoCodeFragment)fragment, position);
            DebugPrinter.printByteCode(clonedMethod, "convertedTypes");
            int startIndex = containingList.indexOf(first);
            int endIndex = containingList.indexOf(last);
            if (startIndex == -1 || endIndex == -1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            block0 : switch (position) {
                case BEFORE: {
                    containingList.insertBefore(first, insertInstructions);
                    break;
                }
                case OVERWRITE: {
                    containingList.insertBefore(first, insertInstructions);
                    AbstractInsnNode current = first;
                    while (true) {
                        AbstractInsnNode next = current.getNext();
                        containingList.remove(current);
                        if (current == last) break block0;
                        current = next;
                    }
                }
                case AFTER: {
                    CodeFragment.ExecutionOutcome insertedExecutionResult = fragment.getExecutionOutcome();
                    if (!executionResult.canFallThrough && insertedExecutionResult.canFallThrough) {
                        throw new CodeFragment.UnreachableInsertionException(this, CodeFragment.InsertionPosition.AFTER);
                    }
                    containingList.insert(last, insertInstructions);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("TODO: not yet implemented for " + this.getClass() + ' ' + fragment.getClass() + ' ' + (Object)((Object)position) + " from " + startIndex + " to " + endIndex);
                }
            }
            containingMethodNodeInfo.markCodeDirty();
        }

        private void convertTypes(MethodNodeInfoCodeFragment insertFragment, CodeFragment.InsertionPosition position) {
            List<IntermediateValue> existingOutputTypes;
            List<IntermediateValue> existingInputTypes;
            switch (position) {
                case BEFORE: {
                    existingOutputTypes = existingInputTypes = this.getInputTypes();
                    break;
                }
                case OVERWRITE: {
                    existingInputTypes = this.getInputTypes();
                    existingOutputTypes = this.getOutputTypes();
                    break;
                }
                case AFTER: {
                    existingOutputTypes = existingInputTypes = this.getOutputTypes();
                    break;
                }
                default: {
                    return;
                }
            }
            List<IntermediateValue> inputTypes = insertFragment.getInputTypes();
            List<IntermediateValue> outputTypes = insertFragment.getOutputTypes();
            if (CollectionUtil.equals(inputTypes, outputTypes, (x$0, x$1) -> AsmCodeFragmentGenerator.ivEqualIgnoringStackOffset(x$0, x$1))) {
                return;
            }
            MethodNode node = insertFragment.containingMethodNodeInfo.node;
            InsnList insns = node.instructions;
            ArrayList<IntermediateValue> movedInputTypes = new ArrayList<IntermediateValue>(existingInputTypes);
            InsnList varInsns = new InsnList();
            int localIndex = this.containingMethodNodeInfo.node.maxLocals;
            int lastStackIndex = Integer.MIN_VALUE;
            ListIterator<IntermediateValue> $ivs = movedInputTypes.listIterator();
            while ($ivs.hasNext()) {
                IntermediateValue iv = $ivs.next();
                if (iv.location.type != IntermediateValue.LocationType.STACK) continue;
                int stackIndex = iv.location.index;
                if (stackIndex <= lastStackIndex) {
                    throw new IllegalStateException("Unexpected stack index" + stackIndex + ", not > last seen index " + lastStackIndex);
                }
                lastStackIndex = stackIndex;
                varInsns.insert((AbstractInsnNode)new VarInsnNode(AsmInstructions.getStoreInstructionForType(iv), localIndex));
                $ivs.set(iv.withLocation(new IntermediateValue.Location(IntermediateValue.LocationType.LOCAL, localIndex, iv.location.name)));
                System.out.println("added local " + localIndex + " for " + iv);
                ++localIndex;
            }
            this.containingMethodNodeInfo.node.maxLocals = localIndex;
            HashMap<Integer, Integer> locals = new HashMap<Integer, Integer>();
            int index = 0;
            block10: for (IntermediateValue iv : inputTypes) {
                if (iv.location.type == IntermediateValue.LocationType.LOCAL && iv.location.index == 0 && !this.containingMethodNodeInfo.getAccessFlags().has(8)) {
                    locals.put(0, 0);
                    continue;
                }
                IntermediateValue input = movedInputTypes.get(index++);
                if (!iv.type.isAssignableFrom(input.type)) {
                    throw new UnsupportedOperationException();
                }
                switch (iv.location.type) {
                    case STACK: {
                        VarInsnNode var = new VarInsnNode(AsmInstructions.getLoadInstructionForType(iv), input.location.index);
                        insns.insert((AbstractInsnNode)var);
                        continue block10;
                    }
                    case LOCAL: {
                        if (input.location.type != IntermediateValue.LocationType.LOCAL) {
                            throw new IllegalStateException();
                        }
                        locals.put(iv.location.index, input.location.index);
                        continue block10;
                    }
                }
                throw new UnsupportedOperationException(iv.toString());
            }
            this.rebaseLocals(locals, insertFragment, this.containingMethodNodeInfo.node.maxLocals);
            insns.insert(varInsns);
            if (existingOutputTypes == existingInputTypes && outputTypes.isEmpty()) {
                for (IntermediateValue iv : existingOutputTypes) {
                    if (iv.location.type != IntermediateValue.LocationType.STACK) continue;
                    if (--localIndex < 0) {
                        throw new IllegalStateException("localIndex < 0");
                    }
                    insns.add((AbstractInsnNode)new VarInsnNode(AsmInstructions.getLoadInstructionForType(iv), localIndex));
                }
            }
            insertFragment.containingMethodNodeInfo.markCodeDirty();
        }

        private void applyInsertionOptions(MethodNodeInfoCodeFragment fragment, CodeFragment.InsertionOptions options) {
            AbstractInsnNode last;
            List<IntermediateValue> inputTypes = fragment.getInputTypes();
            System.out.println(String.join((CharSequence)"\n", inputTypes.stream().map(IntermediateValue::toString).collect(Collectors.toList())));
            ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo = fragment.containingMethodNodeInfo;
            InsnList insns = containingMethodNodeInfo.node.instructions;
            if (options.convertReturnToOutputTypes) {
                LabelNode endLabel = null;
                last = insns.getLast();
                Frame<CombinedValue>[] frames = null;
                for (AbstractInsnNode current : insns.toArray()) {
                    Frame<CombinedValue> frame;
                    int opcode = current.getOpcode();
                    if (opcode < 172 || opcode > 177) continue;
                    if (frames == null) {
                        frames = containingMethodNodeInfo.getStackFrames();
                    }
                    if ((frame = frames[insns.indexOf(current)]).getStackSize() != (opcode == 177 ? 0 : 1)) {
                        throw new UnsupportedOperationException("TODO: handle non-blank stack at return instruction - allowed but not often done" + frame);
                    }
                    if (current != last) {
                        if (endLabel == null) {
                            if (last instanceof LabelNode) {
                                endLabel = (LabelNode)last;
                            } else {
                                endLabel = new LabelNode();
                                insns.insert(last, (AbstractInsnNode)endLabel);
                            }
                        }
                        if (current.getNext() != endLabel) {
                            insns.insert(current, (AbstractInsnNode)new JumpInsnNode(167, endLabel));
                        }
                    }
                    insns.remove(current);
                    containingMethodNodeInfo.markCodeDirty();
                }
            }
            if (options.convertReturnCallToReturnInstruction) {
                AbstractInsnNode current = fragment.getFirstInstruction();
                last = fragment.getLastInstruction();
                while (true) {
                    int opcode;
                    if ((opcode = current.getOpcode()) == 184 || current instanceof MethodInsnNode) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)current;
                        if (JVMUtil.classNameToSlashName(RETURN.class).equals(methodInsnNode.owner)) {
                            MethodDescriptor desc = new MethodDescriptor(methodInsnNode.desc, null);
                            List<Parameter> params = desc.getParameters();
                            Parameter first = params.isEmpty() ? null : params.get(0);
                            insns.insertBefore(current, (AbstractInsnNode)new InsnNode(AsmInstructions.getReturnInstructionForType(first == null ? null : first.type)));
                            containingMethodNodeInfo.markCodeDirty();
                            if (current == last) {
                                insns.remove(current);
                                break;
                            }
                            AbstractInsnNode next = current.getNext();
                            insns.remove(current);
                            current = next;
                        }
                    }
                    if (current == last) break;
                    current = current.getNext();
                }
            }
            if (options.eliminateDeadCode) {
                Frame<CombinedValue>[] frames = containingMethodNodeInfo.getStackFrames();
                for (int i = insns.size() - 1; i >= 0; --i) {
                    if (frames[i] != null) continue;
                    insns.remove(insns.get(i));
                    containingMethodNodeInfo.markCodeDirty();
                }
            }
        }

        private void rebaseLocals(HashMap<Integer, Integer> locals, MethodNodeInfoCodeFragment fragment, int offset) {
            if (offset == 0) {
                return;
            }
            ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo = fragment.containingMethodNodeInfo;
            MethodNode node = containingMethodNodeInfo.node;
            node.maxLocals += offset;
            AbstractInsnNode current = node.instructions.getFirst();
            AbstractInsnNode last = node.instructions.getLast();
            while (true) {
                if (current instanceof VarInsnNode) {
                    int index = ((VarInsnNode)current).var;
                    Integer mapped = locals.get(index);
                    int n = ((VarInsnNode)current).var = mapped == null ? index + offset : mapped;
                }
                if (current == last) {
                    return;
                }
                current = current.getNext();
            }
        }

        @Override
        public <T extends CodeFragment> List<T> findFragments(Class<T> fragmentType) {
            if (fragmentType.isAssignableFrom(this.getClass())) {
                return Collections.singletonList(this);
            }
            Constructor<?> constructor = AsmCodeFragmentGenerator.concreteImplementation(fragmentType).getDeclaredConstructors()[0];
            ArrayList result = new ArrayList();
            AbstractInsnNode insn = this.getFirstInstruction();
            AbstractInsnNode last = this.getLastInstruction();
            while (true) {
                if (constructor.getParameterTypes()[1].isAssignableFrom(insn.getClass())) {
                    result.add(constructor.newInstance(this.containingMethodNodeInfo, insn));
                }
                if (insn == last) break;
                insn = insn.getNext();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsmCodeFragment)) {
                return false;
            }
            AsmCodeFragment other = (AsmCodeFragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ByteCodeInfo.MethodNodeInfo this$containingMethodNodeInfo = this.containingMethodNodeInfo;
            ByteCodeInfo.MethodNodeInfo other$containingMethodNodeInfo = other.containingMethodNodeInfo;
            return !(this$containingMethodNodeInfo == null ? other$containingMethodNodeInfo != null : !this$containingMethodNodeInfo.equals(other$containingMethodNodeInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsmCodeFragment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteCodeInfo.MethodNodeInfo $containingMethodNodeInfo = this.containingMethodNodeInfo;
            result = result * 59 + ($containingMethodNodeInfo == null ? 43 : $containingMethodNodeInfo.hashCode());
            return result;
        }

        public AsmCodeFragment(@NonNull ByteCodeInfo.MethodNodeInfo containingMethodNodeInfo) {
            if (containingMethodNodeInfo == null) {
                throw new NullPointerException("containingMethodNodeInfo");
            }
            this.containingMethodNodeInfo = containingMethodNodeInfo;
        }
    }
}

