/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api.code;

import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.Type;

public final class IntermediateValue {
    public static final UNKNOWN_CONSTANT UNKNOWN = new UNKNOWN_CONSTANT();
    @NonNull
    public final Type type;
    @Nullable
    public final Object constantValue;
    public final Location location;

    public IntermediateValue(@NonNull Type type, @Nullable Object constantValue, Location location) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.constantValue = constantValue;
        this.location = location;
    }

    public String toString() {
        return "IntermediateValue(type=" + this.type + ", constantValue=" + this.constantValue + ", location=" + this.location + ")";
    }

    public IntermediateValue withType(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.type == type ? this : new IntermediateValue(type, this.constantValue, this.location);
    }

    public IntermediateValue withConstantValue(@Nullable Object constantValue) {
        return this.constantValue == constantValue ? this : new IntermediateValue(this.type, constantValue, this.location);
    }

    public IntermediateValue withLocation(Location location) {
        return this.location == location ? this : new IntermediateValue(this.type, this.constantValue, location);
    }

    public static final class UNKNOWN_CONSTANT {
        UNKNOWN_CONSTANT() {
        }

        public String toString() {
            return "Unknown or non-constant value";
        }
    }

    public static class Location {
        @NonNull
        public final LocationType type;
        public final int index;
        @Nullable
        public final String name;

        public Location(@NonNull LocationType type, int index, @Nullable String name) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            this.type = type;
            this.index = index;
            this.name = name;
        }

        public String toString() {
            return "IntermediateValue.Location(type=" + (Object)((Object)this.type) + ", index=" + this.index + ", name=" + this.name + ")";
        }
    }

    public static enum LocationType {
        STACK,
        LOCAL;

    }
}

