/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.Annotated;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.Type;

public class Parameter
implements Annotated {
    @Nullable
    public final String name;
    @NonNull
    public final Type type;
    private final Supplier<List<Annotation>> annotationSupplier;

    private Parameter(@NonNull Type type, @Nullable String name, Supplier<List<Annotation>> annotationSupplier) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.name = name;
        this.annotationSupplier = annotationSupplier;
    }

    public static Parameter of(Type type, String name, @Nullable Supplier<List<Annotation>> annotationSupplier) {
        return new Parameter(type, name, annotationSupplier);
    }

    @Override
    public List<Annotation> getAnnotations() {
        if (this.annotationSupplier == null) {
            return Collections.emptyList();
        }
        return this.annotationSupplier.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "Parameter(name=" + this.getName() + ", type=" + this.getType() + ", annotationSupplier=" + this.annotationSupplier + ")";
    }
}

